/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.predicates.IntegratedPredicateDescription;
import daruma.xml.Lexicon;
import daruma.xml.URI;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.PrefixMap;
import daruma.xml.util.XMLParseErrorException;
import java.util.List;
import org.w3c.dom.Element;

public class FilterParser {
    private FilterParser() {
    }

    public static PredicateDescription parseFilter(Element filterElement, TypeDefinition type, TransformationContext trans, StorageManager storage, PrefixMap prefixMap) throws XMLParseErrorException {
        Lexicon.MispFilter.matchesOrXmlException(filterElement, "in GetFeature/Query");
        List<Element> filterContentElements = ElementUtil.getChildElements(filterElement);
        if (filterContentElements.size() == 0) {
            throw new XMLParseErrorException("Filter tag doesn't have child element, filter specification not found");
        }
        if (filterContentElements.size() >= 2) {
            throw new XMLParseErrorException("too many filter specifications, Filter tag must only have one child element");
        }
        Element filter = filterContentElements.get(0);
        if (filter.getNamespaceURI() == null || !filter.getNamespaceURI().equals(URI.MISP)) {
            throw new XMLParseErrorException("filter \"" + filter.getLocalName() + "\"" + " does not in namespace " + URI.MISP);
        }
        if (IntegratedPredicateDescription.isAcceptablePredicate(filter.getLocalName())) {
            return new IntegratedPredicateDescription(filter, type, trans, storage);
        }
        if (filter.getLocalName().equals("PropertyIsBetween") || filter.getLocalName().equals("PropertyIsLike") || filter.getLocalName().equals("PropertyIsNull")) {
            throw new XMLParseErrorException("sorry, filter \"" + filter.getLocalName() + "\"" + " has not implemented yet");
        }
        if (filter.getLocalName().equals("DWinthin") || filter.getLocalName().equals("Beyond")) {
            throw new XMLParseErrorException("sorry, filter \"" + filter.getLocalName() + "\"" + " has not supported yet");
        }
        throw new XMLParseErrorException("cannot handle filter \"" + filter.getLocalName() + "\"");
    }
}

