/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.handler;

import daruma.xml.handler.MispDefaultHandler;
import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.PrefixMap;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSAXDOMCreateHandler
extends MispDefaultHandler {
    private Document document = null;
    private Element topLevelElement = null;
    private Node currentNode = null;
    private PrefixMap temporalPrefixHolder = new PrefixMap();

    public XSAXDOMCreateHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler) {
        this(out, parser, isTopLevelHandler, null);
    }

    public XSAXDOMCreateHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, Document document) {
        super(out, parser, isTopLevelHandler);
        this.document = document;
        this.topLevelElement = null;
        this.currentNode = null;
    }

    public void reset() {
        this.document = null;
        this.currentNode = null;
    }

    public Element getDocumentElement() {
        return this.topLevelElement;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    protected void xStartDocument() throws SAXException {
        if (this.document == null) {
            try {
                this.document = DOMDocumentFactory.create();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
        }
    }

    protected void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Element e = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attrs.getLength(); ++i) {
            e.setAttributeNS(attrs.getURI(i), attrs.getQName(i), attrs.getValue(i));
        }
        if (this.currentNode == null) {
            ElementUtil.addPrefixMappingToElement(e, super.getPrefixMap());
            this.topLevelElement = e;
        } else {
            this.currentNode.appendChild(e);
        }
        ElementUtil.addPrefixMappingToElement(e, this.temporalPrefixHolder);
        this.temporalPrefixHolder = new PrefixMap();
        this.currentNode = e;
    }

    protected void xEndElement(String uri, String localName, String qName) throws SAXException {
        Node parentNode;
        this.currentNode = parentNode = this.currentNode.getParentNode();
    }

    public void xCharacters(char[] str, int offset, int length) throws SAXException {
        Text text = this.document.createTextNode(new String(str, offset, length));
        assert (this.currentNode != null);
        this.currentNode.appendChild(text);
    }

    protected void xIgnorableWhitespace(char[] str, int offset, int length) {
        if (this.currentNode == null) {
            return;
        }
        Text text = this.document.createTextNode(new String(str, offset, length));
        this.currentNode.appendChild(text);
    }

    protected void xStartPrefixMapping(String prefix, String uri) throws SAXException {
        this.temporalPrefixHolder.put(prefix, uri);
    }
}

