package daruma.xml.test;

import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;

import org.junit.Test;
import junit.framework.TestCase;

public class SimpleXPathTest extends TestCase
{
	@Test
	public	void	testCreate()
	{
		SimpleXPath	p = new SimpleXPath();

		assertNotNull( p );
	}

	@Test
	public	void	testAdd()
	{
		SimpleXPath	p = new SimpleXPath();

		UniversalName	foo = new UniversalName
					  ( "http://foo.bar.org/" , "foo" );

		UniversalName	bar = new UniversalName
					  ( "http://foo.bar.org/" , "bar" );

		assertEquals( 0 , p.getList().size() );
		assertEquals( "" , p.getStringExpression() );

		p.add( foo );
		assertEquals( 1 , p.getList().size() );
		assertEquals( foo , p.getList().get(0) );
		assertEquals( foo.toString() , p.getStringExpression() );

		p.add( foo );
		assertEquals( 2 , p.getList().size() );
		assertEquals( foo , p.getList().get(0) );
		assertEquals( foo , p.getList().get(1) );
		assertEquals( foo.toString() + "/" + foo.toString() ,
			      p.getStringExpression() );

		p.add( bar );
		assertEquals( 3 , p.getList().size() );
		assertEquals( foo , p.getList().get(0) );
		assertEquals( foo , p.getList().get(1) );
		assertEquals( bar , p.getList().get(2) );
		assertEquals( foo.toString() + "/" + foo.toString()
			      + "/" + bar.toString() ,
			      p.getStringExpression() );
	}
}
