#include  "bidirectional_caster.h"
#include  "test_environment.h"

struct Foo
{
	int	x;

	Foo( int  value ) : x( value ) {}
};

template<>
class  bidirectional_caster<Foo, int>
{
public:
	static	Foo	to_first_type( const int &  obj2 )
	{
		return( Foo( obj2 + 1 ) );
	}

	static	int	to_second_type( const Foo &  obj1 )
	{
		return( obj1.x - 1 );
	}
};


int    main( void )
{
	Test_Environment	t;

	{
		//
		// convert int, int
		//
		t.Assert_Equals
		  ( 1 ,
		    bidirectional_caster<int, int>::to_first_type( 1 ) );

		t.Assert_Equals
		  ( 2 ,
		    bidirectional_caster<int, int>::to_second_type( 2 ) );



		//
		// convert Foo, int
		//
		t.Assert_Equals
		  ( 2 ,
		    bidirectional_caster<Foo, int>::to_first_type( 1 ).x );

		t.Assert_Equals
		  ( 1 ,
		    bidirectional_caster<Foo, int>::to_second_type( Foo(2) ) );
	}

	return( t.exit_status() );
}
