#ifdef     LISP_LEX_TEST

#include  <iostream>
#include  "lisp_lex.h"

using namespace std;

static	void	indent( int  level );
static	void	print_obj( const Lisp_Lexical_Object &  obj ,  int  level );

int    main( void )
{
	Lisp_Lexical_Analyzer	lex;
	Lisp_Lexical_Object	obj;

	char	input[1024];
	cerr << "> ";
	// example: "(abc def (ghi jkl) mno ((pqr (stu)))) vwx (yz)"
	cin.getline( input , sizeof(input) );

	if ( ! lex.analyze( input ) )
	{
		cerr << "Error !!" << endl;
	}

	obj = lex.result();

	print_obj( obj , 0 );

	cout << "[" << obj.string_expression() << "]" << endl;

	return( 0 );
}


static
void   indent( int  level )
{
	for ( int i = 0  ;  i < level  ;  i ++ )
	{
		cout  <<  "\t";
	}
}


static
void   print_obj( const Lisp_Lexical_Object &  obj ,  int  level )
{
	indent( level );
	if ( obj.type == Lisp_Lexical_Object::Symbol )
	{
		cout << "Symbol [" << obj.symbol << "]" << endl;
	}
	else if ( obj.type == Lisp_Lexical_Object::List )
	{
		cout << "List";
		if ( ! obj.has_right_paren )
		{
			cout << " (not closed !!)";
		}
		cout << endl;

		for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
		{
			print_obj( obj.list[i] , level + 1 );
		}
	}
	else if ( obj.type == Lisp_Lexical_Object::Top_Level )
	{
		cout << "Top_Level";

		if ( obj.list.empty() )
		{
			cout << " (empty)" << endl;
		}
		else
		{
			cout << endl;

			for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
			{
				print_obj( obj.list[i] , level + 1 );
			}
		}
	}
	else if ( obj.type == Lisp_Lexical_Object::Bad_Type )
	{
		cout << "Bad_Type" << endl;
	}
}
#endif  // LISP_LEX_TEST




#include  "lisp_lex.h"
#include  <iostream>
//
//  Lisp_Lexical_Object
//

using namespace std;

Lisp_Lexical_Object::Lisp_Lexical_Object()
	: type( Top_Level ) ,
#if 0
	  n_quote( 0 ) ,
#endif
	  has_right_paren( false ) ,
	  list() ,
	  symbol()
{
}


Lisp_Lexical_Object::Lisp_Lexical_Object( const string &  str )
	: type( Top_Level ) ,
#if 0
	  n_quote( 0 ) ,
#endif
	  has_right_paren( false ) ,
	  list() ,
	  symbol()
{
	Lisp_Lexical_Analyzer	analyzer;

	(void)analyzer.analyze( str );

	(*this) = analyzer.result();
}

Lisp_Lexical_Object::Lisp_Lexical_Object( std::istream &  istr )
{
	Lisp_Lexical_Analyzer	analyzer;

	(void)analyzer.analyze( istr );

	(*this) = analyzer.result();
}


Lisp_Lexical_Object::Lisp_Lexical_Object( const Lisp_Lexical_Object &  llo )
	: type( llo.type ) ,
#if 0
	  n_quote( llo.n_quote ) ,
#endif
	  has_right_paren( llo.has_right_paren ) ,
	  list( llo.list ) ,
	  symbol( llo.symbol )
{
}

Lisp_Lexical_Object::~Lisp_Lexical_Object()
{
#ifdef LIB_MEMORY
	list.clear();
#endif
}


bool   Lisp_Lexical_Object::listp() const
{
	return( this -> type == Lisp_Lexical_Object::List );
}

bool   Lisp_Lexical_Object::symbolp() const
{
	return( this -> type == Lisp_Lexical_Object::Symbol );
}

size_t  Lisp_Lexical_Object::size() const
{
	return( this -> list.size() );
}

bool   Lisp_Lexical_Object::empty() const
{
	return( this -> list.empty() );
}

bool   Lisp_Lexical_Object::operator== ( const std::string &  symbol ) const
{
	return( this -> symbolp() && this -> symbol == symbol );
}

bool   Lisp_Lexical_Object::operator!= ( const std::string &  symbol ) const
{
	return( ! this -> operator ==(symbol) );
}


const Lisp_Lexical_Object &  Lisp_Lexical_Object::operator[]( size_t  i ) const
{
	return( this -> list[i] );
}

bool   Lisp_Lexical_Object::operator== ( Lisp_Lexical_Object::Object_Type  t )
	const
{
	return(	type == t );
}

bool   Lisp_Lexical_Object::operator!= ( Lisp_Lexical_Object::Object_Type  t )
	const
{
	return(	type != t );
}

bool   Lisp_Lexical_Object::operator< ( const Lisp_Lexical_Object &  x ) const
{
	return( (compare( x ) < 0) );
}


int    Lisp_Lexical_Object::compare( const Lisp_Lexical_Object &  x ) const
{
	if ( this -> type  !=  x.type )
	{
		return(   static_cast<int>(x.type)
			- static_cast<int>(this -> type) );
	}

	switch( this -> type )
	{
	case  Lisp_Lexical_Object::Symbol:
		return( symbol.compare( x.symbol ) );
		break;

	case  Lisp_Lexical_Object::List:
	case  Lisp_Lexical_Object::Top_Level:
		if ( this -> list.size() != x.list.size() )
		{
			// XXX
			return( static_cast<int>(this -> list.size())
				- static_cast<int>(x.list.size()) );
		}

		if ( this -> has_right_paren != x.has_right_paren )
		{
			return( ((this -> has_right_paren) ? -1 : 1) );
		}

		for ( size_t  i = 0  ;  i < this -> list.size()  ;  i ++ )
		{
			int	cmp = this -> list[i].compare( x.list[i] );
			if ( cmp != 0 )
			{
				return( cmp );
			}
		}

		return( 0 );
		break;

	case  Lisp_Lexical_Object::Bad_Type:
	default:
		return( 0 );
		break;
	}
}


//
//  Lisp_Lexical_Analyzer
//

using namespace std;

Lisp_Lexical_Analyzer::Lisp_Lexical_Analyzer()
	: escaped( false ) , in_string( false )
{
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );
}


Lisp_Lexical_Analyzer::Lisp_Lexical_Analyzer( const string &  str )
	: escaped( false ) , in_string( false )
{
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );

	(void)analyze( str );
}


Lisp_Lexical_Analyzer::Lisp_Lexical_Analyzer( std::istream &  istr )
	: escaped( false ) , in_string( false )
{
	Lisp_Lexical_Object	obj;

	dummy_obj.push_back( obj );

	object_stack.push( dummy_obj.begin() );
	object_stack.push( dummy_obj.begin() );

	(void)analyze( istr );
}



Lisp_Lexical_Analyzer::~Lisp_Lexical_Analyzer()
{
#ifdef LIB_MEMORY
	dummy_obj[0].list.clear();
	dummy_obj.clear();
#endif
}


Lisp_Lexical_Object  Lisp_Lexical_Analyzer::result()
{
	return( dummy_obj[0] );
}


bool  Lisp_Lexical_Analyzer::analyze( const string &  input )
{
	bool	ret = true;

	for ( size_t i = 0  ;  i < input.length()  ;  i ++ )
	{
		ret = analyze( input[i] );
	}

	return( ret );
}

bool  Lisp_Lexical_Analyzer::analyze( istream &  input )
{
	bool	ret = true;

	while( input.good() )
	{
		char	ch;
		input.get(ch);
		ret = analyze( ch );
	}

	return( ret );
}


bool  Lisp_Lexical_Analyzer::analyze( char  ch )
{
#define	SP (object_stack.top())

	bool	continue_flag = true;

	while( continue_flag )
	{
		continue_flag = false;

		switch( (*SP).type )
		{
		case  Lisp_Lexical_Object::Bad_Type:
			return( false );
			break;

		case  Lisp_Lexical_Object::Top_Level:
			switch( ch )
			{
			case  ' ':
			case  '\t':
			case  '\n':
				// skip it !!
				break;

			case  '(':
			      {
				Lisp_Lexical_Object	lis;
				lis.type = Lisp_Lexical_Object::List;
				(*SP).list.push_back( lis );
				object_stack.push( (*SP).list.end() - 1 );
				break;
			      }

			case  ')':
				(*SP).type = Lisp_Lexical_Object::Bad_Type;
				return( false );
				break;

			case  '"':
				this -> in_string = true;
				/* FALLTHROUGH */
			default:
			      {
				Lisp_Lexical_Object	sym;
				sym.type = Lisp_Lexical_Object::Symbol;
				(*SP).list.push_back( sym );
				object_stack.push( (*SP).list.end() - 1 );
				(*SP).symbol.append( 1 , ch );
				break;
			      }
			}
			break;

		case  Lisp_Lexical_Object::List:
			switch( ch )
			{
			case  ' ':
			case  '\t':
			case  '\n':
				// skip it !!
				break;

			case  '(':
			      {
				Lisp_Lexical_Object	lis;
				lis.type = Lisp_Lexical_Object::List;
				(*SP).list.push_back( lis );
				object_stack.push( (*SP).list.end() - 1 );
				break;
			      }

			case  ')':
			      {
				(*SP).has_right_paren = true;
				object_stack.pop();
				break;
			      }

			case  '"':
				this -> in_string = true;
				/* FALLTHROUGH */
			default:
			      {
				Lisp_Lexical_Object	sym;
				sym.type = Lisp_Lexical_Object::Symbol;
				(*SP).list.push_back( sym );
				object_stack.push( (*SP).list.end() - 1 );
				(*SP).symbol.append( 1 , ch );
				break;
			      }
			}
			break;

		case  Lisp_Lexical_Object::Symbol:
			if ( this -> in_string )
			{
				(*SP).symbol += ch;

				if ( this -> escaped )
				{
					this -> escaped = false;
					break;
				}

				switch( ch )
				{
				case  '\\':
					this -> escaped = true;
					break;

				case  '"':
					this -> in_string = false;
					object_stack.pop();
					break;

				default:
					break;
				}
			}
			else
			{
				switch( ch )
				{
				case  ' ':
				case  '\t':
				case  '\n':
					object_stack.pop();
					break;

				case  '(':
				      {
					object_stack.pop();
					Lisp_Lexical_Object	lis;
					lis.type = Lisp_Lexical_Object::List;
					(*SP).list.push_back( lis );
					object_stack.push
						( (*SP).list.end() - 1 );
					break;
				      }

				case  ')':
					object_stack.pop();
					continue_flag = true;
					break;

				case  '"':
					object_stack.pop();
					continue_flag = true;
					break;

				default:
					(*SP).symbol += ch;
					break;
				}
			}
			break;
		}
	}

	return( true );
#undef	SP
}


std::string  Lisp_Lexical_Object::string_expression() const
{
	return( convert_to_string_expression( *this ) );
}

std::string  Lisp_Lexical_Object::convert_to_string_expression
				    ( const Lisp_Lexical_Object &  obj )
{
	if ( obj.type == Lisp_Lexical_Object::Symbol )
	{
		return( obj.symbol );
	}
	else if ( obj.type == Lisp_Lexical_Object::List )
	{
		std::string	buf;

		buf = "(";

		for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
		{
			if ( i != 0 )
			{
				buf += " ";
			}

			buf += convert_to_string_expression( obj.list[i] );
		}

		if ( obj.has_right_paren )
		{
			buf += ")";
		}

		return( buf );
	}
	else if ( obj.type == Lisp_Lexical_Object::Top_Level )
	{
		std::string	buf;

		for ( size_t  i = 0  ;  i < obj.list.size()  ;  i ++ )
		{
			if ( i != 0 )
			{
				buf += " ";
			}

			buf += convert_to_string_expression( obj.list[i] );
		}

		return( buf );
	}
	else if ( obj.type == Lisp_Lexical_Object::Bad_Type )
	{
		return( "" );
	}

	return( "" );
}
