#ifndef	   LISP_LEX_H_INCLUDED
#define	   LISP_LEX_H_INCLUDED

// lisp_lex.h --- lexical analyze system for lisp code.

// Copyright (C) 1998 H. Shimora

// Author:		H. Shimora
// Created:		Sep 18 1998
// Last-Modified:	Sep 30 1998
// Version:		0.11

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.10  Sep 19 1998	list & symbol analysis only.
//
// version 0.11  Sep 30 1998	Lisp_Lexical_Object::operator==
//				( Lisp_Lexical_Object::Object_Type ) added.
//
//				Lisp_Lexical_Object::
//				Lisp_Lexical_Object( string ) added.
//
//				Lisp_Lexical_Analyzer::
//				Lisp_Lexical_Analyzer( string ) added.
//
//				bug fix. (for  too much ')' in top level)
//
//

// TODO:
//  * quote(') support.
//  * replace char to template parameter.
//  * error handling.


#ifdef HAVE_CONFIG_H
# include  "config.h"
#endif


//
//  Lisp_Lexical_Object
//
#include  <vector>
#include  <string>
#include  <iosfwd>

struct  Lisp_Lexical_Object
{
	typedef  enum{ List , Symbol , Top_Level , Bad_Type }  Object_Type;

	Object_Type			type;
#if 0
	int				n_quote;  // unused in this version.
#endif

	bool					has_right_paren;
	std::vector<Lisp_Lexical_Object>	list;

	std::string				symbol;

protected:
	int	compare( const Lisp_Lexical_Object & ) const;

private:
	static	std::string  convert_to_string_expression
					( const Lisp_Lexical_Object &  obj );

public:
	 Lisp_Lexical_Object();
	 Lisp_Lexical_Object( const Lisp_Lexical_Object & );
	 Lisp_Lexical_Object( const std::string & );
	 Lisp_Lexical_Object( std::istream & );

	~Lisp_Lexical_Object();

	bool	operator== ( Lisp_Lexical_Object::Object_Type ) const;
	bool	operator!= ( Lisp_Lexical_Object::Object_Type ) const;
	bool	operator<  ( const Lisp_Lexical_Object & ) const;

	bool	operator== ( const std::string &  symbol ) const;
	bool	operator!= ( const std::string &  symbol ) const;

	bool	listp() const;
	bool	symbolp() const;

	size_t	size() const;
	bool	empty() const;
	const Lisp_Lexical_Object &	operator[]( size_t  i ) const;

	std::string	string_expression() const;
};


//
//  Lisp_Lexical_Analyzer
//
#include  <vector>
#include  <stack>
#include  <string>

class  Lisp_Lexical_Analyzer
{
protected:
	std::stack< std::vector<Lisp_Lexical_Object>::iterator >
							object_stack;

	bool						escaped;
	bool						in_string;

	std::vector<Lisp_Lexical_Object>		dummy_obj;

private:
	 Lisp_Lexical_Analyzer( const Lisp_Lexical_Analyzer & );// not allowed.
	 Lisp_Lexical_Analyzer & operator =
			( const Lisp_Lexical_Analyzer & );// not allowed.

public:
	 Lisp_Lexical_Analyzer();
	 Lisp_Lexical_Analyzer( const std::string & );
	 Lisp_Lexical_Analyzer( std::istream & );
	~Lisp_Lexical_Analyzer();

	bool			analyze( const std::string &  input );
	bool			analyze( std::istream &  input );
	bool			analyze( char  ch );

	Lisp_Lexical_Object	result();
};


#endif	/* LISP_LEX_H_INCLUDED */
