#ifndef	   STRING_EXTENSION_H_INCLUDED
#define	   STRING_EXTENSION_H_INCLUDED

// Author:		H. Shimora
// Created:		Oct 26 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Oct 26 2002    base version.
//
//

#include  <string>
#include  <vector>
#if ! defined( NO_INTTYPES_H )
#include  <inttypes.h>
#endif


namespace  String_Extension
{

	extern	void		split_by_char_set
				    ( std::vector<std::string> *  result ,
				      const std::string &  str ,
				      const std::string &  char_set ,
				      bool  do_cutoff_edge = false );

	extern	bool		separate_to_2_parts
				    ( std::string *  first ,
				      std::string *  second ,
				      const std::string &  str ,
				      char  separator ,
				      bool  do_cutoff_edge = false );

	extern	std::string	join
				( const std::string &  separator ,
				  const std::vector<std::string> &  values );

	extern	bool		string_to_integer( int *     result ,
						   const std::string &  str );
	extern	bool		string_to_long   ( long *    result ,
						   const std::string &  str );
#if ! defined( NO_INTTYPES_H )
	extern	bool		string_to_int64_t( int64_t * result ,
						   const std::string &  str );
#endif
	extern	bool		string_to_double ( double *  result ,
						   const std::string &  str );

	extern	bool		string_to_bool_literal_true_false
						 ( bool *  result ,
						   const std::string &  str );

	extern	void		double_to_string ( std::string *  result ,
						   double  value );

	extern	std::string	double_to_string ( double  value );

	extern	void		int_to_string    ( std::string *  result ,
						   int  value );

	extern	std::string	int_to_string    ( int  value );

	extern	void		long_to_string   ( std::string *  result ,
						   long  value );

	extern	std::string	long_to_string   ( long  value );

#if ! defined( NO_INTTYPES_H )
	extern	void		int64_t_to_string( std::string *  result ,
						   int64_t  value );

	extern	std::string	int64_t_to_string( int64_t  value );
#endif

	extern	std::string	chomp( const std::string &  str );
	extern	void		chomp( std::string *  str );

	extern	std::string	chomp_an_extension
					( const std::string &  from );

	extern	void		chomp_an_extension
					( std::string *  str ,
					  const std::string &  from );

	extern	std::string	cutoff_edge( const std::string &  str ,
					     const std::string &  char_set );
	extern	void		cutoff_edge( std::string *  str ,
					     const std::string &  char_set );


	extern	std::string	cutoff_edge_spaces( const std::string &  str );
	extern	void		cutoff_edge_spaces( std::string *  str );

	extern	bool		starts_with( const std::string &  prefix ,
					     const std::string &  str );

	extern	bool		ends_with( const std::string &  suffix ,
					   const std::string &  str );

	extern	std::string	toupper( const std::string &  str );
	extern	std::string	tolower( const std::string &  str );
	extern	std::string	capitalize_first( const std::string &  str );

	extern	bool		unquote( std::string *  result ,
					 const std::string &  str );

	extern	std::string	replace( const std::string &  str ,
					 char  from_char ,
					 const std::string &  to_string );

	extern	std::string	repeat_string( const std::string &  str ,
					       size_t  n );


} // end of namespace String_Extension


#endif	/* STRING_EXTENSION_H_INCLUDED */
