#include  "sockctl.h"
#include  "compat_stringstream.h"
#include  "system_call_wrapper.h"
#include  <sys/types.h>
#include  <sys/time.h>
#include  "posix_compat_sys_select.h"
#include  <unistd.h>
#include  <string>
#include  <cstdio>
#include  <stdexcept>

Sockctl::Sockctl( const ref_count_ptr<Abstract_IO> &  stream_1 ,
		  const ref_count_ptr<Abstract_IO> &  stream_2 ,
		  bool  debug )
	: stream_1( stream_1 ) , stream_2( stream_2 ) , debug( debug )
{
}

Sockctl::~Sockctl()
{
}

void   Sockctl::run()
{
	for(;;)
	{
		if ( this -> debug )
		{
			std::cerr << std::endl;
			std::cerr << "socket recv eof = "
				  << this -> stream_1 -> input_eof()
				  << std::endl;
			std::cerr << "socket send eof = "
				  << this -> stream_1 -> output_eof()
				  << std::endl;
			std::cerr << "stdin       eof = "
				  << this -> stream_2 -> input_eof()
				  << std::endl;
			std::cerr << "stdout      eof = "
				  << this -> stream_2 -> output_eof()
				  << std::endl;
			std::cerr << std::endl;
		}


		if ( (this -> stream_1 -> input_eof()
		      && this -> stream_1 -> output_eof())
		  || (this -> stream_2 -> input_eof()
		      && this -> stream_2 -> output_eof()) )
		{
			break;
		}


		std::vector<int>  fds_1 = this -> stream_1 -> input_fds();
		std::vector<int>  fds_2 = this -> stream_2 -> input_fds();

		std::vector<int>  fds;
		fds.insert( fds.end() , fds_1.begin() , fds_1.end() );
		fds.insert( fds.end() , fds_2.begin() , fds_2.end() );


		int	max_fd = -1;

		fd_set	readfd;
		FD_ZERO( &readfd );

		for ( size_t  i = 0  ;  i < fds.size()  ;  i ++ )
		{
			FD_SET( fds[i] , &readfd );

			if ( max_fd < fds[i] )
			{
				max_fd = fds[i];
			}
		}

		if ( fds.size() != 0
		  && ::select( max_fd + 1 ,
			       &readfd ,
			       static_cast<fd_set *>(0) ,
			       static_cast<fd_set *>(0) ,
			       static_cast<struct timeval *>(0) ) >= 1 )
		{
			if ( stream_1 -> input_poll() )
			{
				unsigned char	buf[BUFSIZ];

				int	n_read = stream_1
						 -> read( buf , BUFSIZ );

				if ( n_read == 0 || n_read == -1 )
				{
					stream_2 -> output_close();
				}
				else
				{
					stream_2 -> write( buf , n_read );
				}
			}

			if ( stream_2 -> input_poll() )
			{
				unsigned char	buf[BUFSIZ];
				int	n_read = stream_2
						 -> read( buf , BUFSIZ );

				if ( n_read == 0 || n_read == -1 )
				{
					stream_1 -> output_close();
				}
				else
				{
					stream_1 -> write( buf , n_read );
				}
			}
		}
	}
}
