/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

public class SQLDataType {
    private static final int INDEX_LENGTH = 128;
    private String sqlBaseDataTypeName;
    private String sqlRetrieveFunction;
    private Class javaClass;

    public SQLDataType(String sqlBaseDataTypeName, String sqlRetrieveFunction, Class javaClass) {
        this.sqlBaseDataTypeName = sqlBaseDataTypeName;
        this.sqlRetrieveFunction = sqlRetrieveFunction;
        this.javaClass = javaClass;
    }

    public SQLDataType(String sqlBaseDataTypeName, Class javaClass) {
        this.sqlBaseDataTypeName = sqlBaseDataTypeName;
        this.sqlRetrieveFunction = null;
        this.javaClass = javaClass;
    }

    public String getSQLBaseDataTypeString() {
        return this.sqlBaseDataTypeName;
    }

    public String getSQLRetrieveColumnString(String columnName) {
        if (this.sqlRetrieveFunction != null) {
            return this.sqlRetrieveFunction + "(`" + columnName + "`)";
        }
        return columnName;
    }

    public String getSQLRetrieveColumnStringForRawSQLString(String columnName) {
        if (this.sqlRetrieveFunction != null) {
            return this.sqlRetrieveFunction + "(`" + columnName + "`)";
        }
        return "`" + columnName + "`";
    }

    public String getIndexString(String columnName) {
        if (this.needsIndexLength()) {
            return "INDEX(`" + columnName + "`(" + 128 + "))";
        }
        return "INDEX(`" + columnName + "`)";
    }

    private boolean needsIndexLength() {
        return this.sqlBaseDataTypeName.equals("blob") || this.sqlBaseDataTypeName.equals("longblob") || this.sqlBaseDataTypeName.equals("geometry");
    }

    public boolean isTimeFamilyType() {
        return this.sqlBaseDataTypeName.equals("datetime") || this.sqlBaseDataTypeName.equals("timestamp");
    }

    private boolean isSpatialType() {
        return this.sqlBaseDataTypeName.equals("geometry");
    }

    public Class getJavaClass() {
        return this.javaClass;
    }
}

