/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml;

import daruma.util.Pair;
import daruma.xml.NameSpace;
import daruma.xml.util.XMLParseErrorException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class DeclaredName {
    public NameSpace ns;
    public String localname;

    public DeclaredName() {
        this.set(null, null);
    }

    public DeclaredName(String localname) {
        this.set(localname, null);
    }

    public DeclaredName(String localname, NameSpace ns) {
        this.set(localname, ns);
    }

    public DeclaredName set(String localname) {
        return this.set(localname, null);
    }

    public DeclaredName set(String localname, NameSpace ns) {
        this.localname = localname;
        this.ns = ns;
        return this;
    }

    public String genQName() {
        return this.genQName(this.ns);
    }

    public String genQName(NameSpace ns) {
        return NameSpace.genQName(ns, this.localname);
    }

    public String genQName(String prefix) {
        return NameSpace.genQName(prefix, this.localname);
    }

    public static String getLocalNameInQName(String qname) {
        int seppos = qname.indexOf(":");
        if (seppos < 0) {
            return qname;
        }
        return qname.substring(seppos + 1);
    }

    public static String getPrefixInQName(String qname) {
        int seppos = qname.indexOf(":");
        if (seppos < 0) {
            return null;
        }
        return qname.substring(0, seppos);
    }

    public boolean equals(Node node) {
        return this.matches(node);
    }

    public boolean matches(Node node) {
        return this.matches(node, true);
    }

    public boolean matches(Node node, boolean checkNsP) {
        return node.getLocalName().equals(this.localname) && (!checkNsP || this.ns == null || this.ns.includes(node));
    }

    public boolean matches(String nsUri, String localname) {
        return this.localname.equals(localname) && this.ns.equals(nsUri);
    }

    public boolean matchesOrXmlException(Node node, String description) throws XMLParseErrorException {
        if (!this.matches(node)) {
            throw new XMLParseErrorException(this.genExceptionMessage(node, description, this.matches(node, false)));
        }
        return true;
    }

    public boolean matchesOrSaxException(Node node, Locator locator, String description) throws SAXParseException {
        if (!this.matches(node)) {
            throw new SAXParseException(this.genExceptionMessage(node, description, this.matches(node, false)), locator);
        }
        return true;
    }

    public boolean matchesOrSaxException(String nsUri, String prefix, String localname, Locator locator, String description) throws SAXParseException {
        if (!this.matches(nsUri, localname)) {
            throw new SAXParseException(this.genExceptionMessage(nsUri, prefix, localname, description, true), locator);
        }
        return true;
    }

    public String genExceptionMessage(Node node, String description, boolean isNameSpaceError) {
        return this.genExceptionMessage(node.getNamespaceURI(), node.getPrefix(), node.getLocalName(), description, isNameSpaceError);
    }

    public String genExceptionMessage(String nsUri, String prefix, String localname, String description, boolean isNameSpaceError) {
        String tagName;
        String descStr = description == null ? "" : "\n\t(" + description + ")";
        String string = tagName = prefix != null ? NameSpace.genQName(prefix, localname) : NameSpace.genUName(nsUri, localname);
        if (isNameSpaceError) {
            return "Unexpected XML Node:[" + tagName + "]:" + "Namespace \n\t{" + this.ns.uri + "}\n is expected. " + "But \n\t{" + nsUri + "}\n is used." + descStr;
        }
        return "Unexpected XML Node:[" + tagName + "]:" + "Localname '" + this.localname + "' in namespace{" + this.ns.uri + "} is expected." + descStr;
    }

    public int hashCode() {
        return this.ns.hashCode() + this.localname.hashCode();
    }

    public static class Table<Value> {
        private List<Entry> list = new ArrayList<Entry>();

        public void put(DeclaredName dname, Value value) {
            this.list.add(new Entry(dname, value));
        }

        public Value get(DeclaredName dname) {
            for (Entry entry : this.list) {
                if (!entry.getName().equals(dname)) continue;
                return entry.getValue();
            }
            return null;
        }

        public Value get(Element element) {
            Entry entry = this.getEntry(element);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Entry getEntry(Element element) {
            for (Entry entry : this.list) {
                if (!entry.getName().matches(element)) continue;
                return entry;
            }
            return null;
        }

        public Value getByLocalName(String localname) {
            Entry entry = this.getEntryByLocalName(localname);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Entry getEntryByLocalName(String localname) {
            for (Entry entry : this.list) {
                if (!entry.getName().localname.equals(localname)) continue;
                return entry;
            }
            return null;
        }

        public class Entry
        extends Pair<DeclaredName, Value> {
            public Entry(DeclaredName dname, Value value) {
                super(dname, value);
            }

            public DeclaredName getName() {
                return (DeclaredName)this.getFirst();
            }

            public Value getValue() {
                return this.getSecond();
            }
        }
    }
}

