/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml;

import daruma.xml.util.DOMDocumentFactory;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NameSpace {
    public static final String PrefixSeparator = ":";
    public static final String UNameUriPrefix = "{";
    public static final String UNameUriSuffix = "}";
    public String uri;
    public String defaultPrefix;
    public static final Table DefaultTable = new Table();
    public static Element DefaultContext = null;
    public static final NameSpace SOAP_ENV = new NameSpace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", true);
    public static final NameSpace XMLNS = new NameSpace("xmlns", "http://www.w3.org/2000/xmlns/", true);
    public static final NameSpace XML_SCHEMA = new NameSpace("xsd", "http://www.w3.org/2001/XMLSchema", true);
    public static final NameSpace GML = new NameSpace("gml", "http://www.opengis.net/gml", true);
    public static final NameSpace WFS = new NameSpace("wfs", "http://www.opengis.net/wfs", true);
    public static final NameSpace MISP = new NameSpace("misp", "http://www.infosharp.org/misp", true);
    public static final NameSpace MISP_ERROR = new NameSpace("misp-error", "http://www.infosharp.org/misp/error", true);

    private static Element prepareDefaultContext() {
        if (DefaultContext == null) {
            try {
                Document doc = DOMDocumentFactory.create();
                DefaultContext = doc.createElement("DefaultContxt");
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        return DefaultContext;
    }

    public NameSpace(String uri) {
        this.set(uri);
    }

    public NameSpace(String prefix, String uri) {
        this.set(prefix, uri);
    }

    public NameSpace(String prefix, String uri, Table table) {
        this.set(prefix, uri, table);
    }

    public NameSpace(String prefix, String uri, boolean registerP) {
        this.set(prefix, uri, registerP);
    }

    public NameSpace set(String uri) {
        return this.set(null, uri, false);
    }

    public NameSpace set(String prefix, String uri) {
        return this.set(prefix, uri, false);
    }

    public NameSpace set(String prefix, String uri, boolean registerP) {
        return this.set(prefix, uri, registerP ? DefaultTable : null);
    }

    public NameSpace set(String prefix, String uri, Table nsTable) {
        this.defaultPrefix = prefix;
        this.uri = uri;
        if (nsTable != null) {
            nsTable.put(this);
        }
        return this;
    }

    public static String genQName(String prefix, String localname) {
        if (prefix == null || prefix.length() == 0) {
            return localname;
        }
        return prefix + PrefixSeparator + localname;
    }

    public static String genQName(NameSpace ns, String localname) {
        if (ns == null) {
            return NameSpace.genQName((String)null, localname);
        }
        return NameSpace.genQName(ns.defaultPrefix, localname);
    }

    public String genQNameFor(String localname) {
        return NameSpace.genQName(this, localname);
    }

    public static String genUName(String nsUri, String localname) {
        if (nsUri == null || nsUri.length() == 0) {
            return localname;
        }
        return UNameUriPrefix + nsUri + UNameUriSuffix + localname;
    }

    public static String genUName(NameSpace ns, String localname) {
        if (ns == null) {
            return NameSpace.genUName((String)null, localname);
        }
        return NameSpace.genUName(ns.uri, localname);
    }

    public String genUNameFor(String localname) {
        return NameSpace.genUName(this, localname);
    }

    public static String genXmlNsAttrName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return NameSpace.XMLNS.defaultPrefix;
        }
        return NameSpace.genQName(NameSpace.XMLNS.defaultPrefix, prefix);
    }

    public String genXmlNsAttrName() {
        return this.genXmlNsAttrName(false);
    }

    public String genXmlNsAttrName(boolean defaultp) {
        if (defaultp) {
            return NameSpace.genXmlNsAttrName(null);
        }
        return NameSpace.genXmlNsAttrName(this.defaultPrefix);
    }

    public boolean addNsDeclToIfNeeded(Element element) {
        return NameSpace.addNsDeclToIfNeeded(element, this.defaultPrefix, this.uri);
    }

    public static boolean addNsDeclToIfNeeded(Element element, String prefix, String uri) {
        String predefined = NameSpace.findPredefinedPrefixIn((Node)element, uri);
        if (predefined == null || !predefined.equals(prefix)) {
            element.setAttributeNS(NameSpace.XMLNS.uri, NameSpace.genXmlNsAttrName(prefix), uri);
            return true;
        }
        return false;
    }

    public String findPredefinedPrefixIn(Node element) {
        return NameSpace.findPredefinedPrefixIn(element, this);
    }

    public static String findPredefinedPrefixIn(Node element, NameSpace ns) {
        if (ns != null) {
            return ns.findPredefinedPrefixIn(element);
        }
        return null;
    }

    public static String findPredefinedPrefixIn(Node element, String uri) {
        if (element == null || uri == null || element instanceof Document) {
            return null;
        }
        if (element.isDefaultNamespace(uri)) {
            return "";
        }
        return element.lookupPrefix(uri);
    }

    public String findPredefinedNamespaceUriIn(Node element, String prefix) {
        return element.lookupNamespaceURI(prefix);
    }

    public boolean includes(Node node) {
        String uri = node.getNamespaceURI();
        if (uri == null) {
            return false;
        }
        return uri.equals(this.uri);
    }

    public boolean equals(String nsUri) {
        return this.uri.equals(nsUri);
    }

    public boolean equals(NameSpace ns) {
        return this.equals(ns.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static {
        NameSpace.prepareDefaultContext();
        for (NameSpace ns : NameSpace.DefaultTable.prefixTable.values()) {
            ns.addNsDeclToIfNeeded(DefaultContext);
        }
    }

    public static class Table {
        public HashMap<String, NameSpace> uriTable = new HashMap();
        public HashMap<String, NameSpace> prefixTable = new HashMap();

        public NameSpace put(NameSpace ns) {
            this.prefixTable.put(ns.defaultPrefix, ns);
            this.uriTable.put(ns.uri, ns);
            return ns;
        }

        public NameSpace getByPrefix(String prefix) {
            return this.prefixTable.get(prefix);
        }

        public NameSpace getByUri(String uri) {
            return this.uriTable.get(uri);
        }
    }
}

