package daruma.sql.test;

import daruma.sql.SQLStringConverter;

import org.junit.Test;
import junit.framework.TestCase;


public class SQLStringConverterTest extends TestCase
{
	@Test
	public	void	testQuote()
	{
		// [abc"def] -> [abc\"def]
		this.check( "abc\\\"def" , "abc\"def" );

		// [abc'def] -> [abc\'def]
		this.check( "abc\\'def" , "abc'def" );

		// [abc(NUL)def] -> [abc\(NUL)def]
		this.check( "abc\\\0def" , "abc\0def" );

		// [abc\def] -> [abc\\def]
		this.check( "abc\\\\def" , "abc\\def" );

		// [abc(CR)def] -> [abc\(CR)def]
		this.check( "abc\\\rdef" , "abc\rdef" );

		// [abc(LF)def] -> [abc\(LF)def]
		this.check( "abc\\\ndef" , "abc\ndef" );

		// [abc(CR)(LF)def] -> [abc\(CR)\(LF)def]
		this.check( "abc\\\r\\\ndef" , "abc\r\ndef" );

		// [abc(C-Z)def] -> [abc\(C-Z)def]
		this.check( "abc\\\0x1a" + "def" , "abc\0x1a" + "def" );


		this.check( "" , "" );
		this.check( "a" , "a" );
		this.check( "\\\\" , "\\" );
	}


	private	void	check( String  expected ,  String  input )
	{
		/*
		final String	converted = SQLStringConverter
					      .encodeStringValue( input );

		assertEquals( expected , converted );

		final String	decoded = SQLStringConverter
					      .decodeStringValue( converted );

		assertEquals( input , decoded );
		*/
	}
}
