package daruma.xml.handler.test.sample;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

import java.io.OutputStream;
import java.io.PrintWriter;

public class SampleErrorHandler implements ErrorHandler
{
	private	PrintWriter	out;

	public	SampleErrorHandler( OutputStream  out )
	{
		this.out = new PrintWriter( out );
	}

	public	void	fatalError( SAXParseException  exception )
	{
		this.printError( exception , "fatal error" );
	}

	public	void	error( SAXParseException  exception )
	{
		this.printError( exception , "error" );
	}

	public	void	warning( SAXParseException exception )
	{
		this.printError( exception , "warning" );
	}


	private	void	printError( SAXParseException  e ,  String  type )
	{
		this.out.println( type + ": "
				  + "line " + e.getLineNumber() + ", "
				  + "column " + e.getColumnNumber() + ": "
				  + e.getMessage() );

		this.out.flush();
	}
}
