package daruma.xml.util;

import daruma.xml.util.DOMDocumentFactory;
import daruma.xml.URI;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.Locator;


public class ErrorDocumentBuilder
{
	private	ErrorDocumentBuilder()
	{
	}

	public	static	Document	create( String  message ,
						Locator  locator )
				  throws ParserConfigurationException
	{
		Document	doc;
		try
		{
			doc = DOMDocumentFactory.create();
		}
		catch( ParserConfigurationException  e )
		{
			throw e;
		}

		Element	top = doc.createElementNS( URI.MISP_ERROR ,
						   "Error" );
		top.setAttribute( "line" ,
				  Integer.toString
					  ( locator.getLineNumber() ) );
		top.setAttribute( "column" ,
				  Integer.toString
					  ( locator.getColumnNumber() ) );

		Element	mes = doc.createElementNS( URI.MISP_ERROR ,
						   "Message" );

		Text	errorMessageNode = doc.createTextNode( message );

		mes.appendChild( errorMessageNode );

		top.appendChild( mes );

		doc.appendChild( top );

		return( doc );
	}
}
