package daruma.xml.util;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;


public class PrefixMap
{
	private Map<String, String>		currentMap;
	private Map<String, Stack<String> >	stackMap;

	public	PrefixMap()
	{
		this.currentMap = new HashMap<String, String>();
		this.stackMap   = new HashMap<String, Stack<String> >();
	}

	public	Set< Map.Entry<String, String> >	entrySet()
	{
		return this.currentMap.entrySet();
	}

	public	Set<String>	keySet()
	{
		return this.currentMap.keySet();
	}

	public	String	get( String  prefix )
	{
		if ( prefix == null )
		{
			return this.currentMap.get( "" );
		}
		else
		{
			return this.currentMap.get( prefix );
		}
	}

	public	void	put( String  prefix ,  String  namespaceURI )
	{
		if ( prefix == null )
		{
			prefix = "";
		}

		this.currentMap.put( prefix , namespaceURI );

		Stack<String>	namespaceStack = this.stackMap.get( prefix );

		if ( namespaceStack == null )
		{
			namespaceStack = new Stack<String>();
			namespaceStack.push( namespaceURI );

			this.stackMap.put( prefix , namespaceStack );
		}
		else
		{
			namespaceStack.push( namespaceURI );
		}
	}

	public	void	remove( String  prefix )
	{
		if ( prefix == null )
		{
			prefix = "";
		}

		Stack<String>	namespaceStack = this.stackMap.get( prefix );

		// XXX
		if ( namespaceStack == null )
		{
			return;
		}

		namespaceStack.pop();

		if ( namespaceStack.empty() )
		{
			this.currentMap.remove( prefix );
			this.stackMap.remove( prefix );
		}
		else
		{
			this.currentMap.put( prefix , namespaceStack.peek() );
		}
	}

	public	int	size()
	{
		return this.currentMap.size();
	}

	public	void	clear()
	{
		this.currentMap.clear();
		this.stackMap.clear();
	}

	/*
	public	String	getNamespace( String  prefix )
	{
		return this.get( prefix );
	}
	*/
}
