/*
 * Decompiled with CFR 0.152.
 */
package daruma.global_switch;

import daruma.util.FatalException;
import daruma.util.PropertyReader;

public class ImplementationSwitches {
    private static final String ENABLE_GEOMETRY_CONVERSION_PROPERTY = "daruma.geometry.enable_conversion";
    private static final boolean ENABLE_GEOMETRY_CONVERSION_DEFAULT = true;
    private boolean enableGeometryConversion = PropertyReader.getProperty("daruma.geometry.enable_conversion", true);
    private String BACKEND_DB_TYPE_PROPERTY = "daruma.db.backend";
    private static final String BACKEND_DB_TYPE_DEFAULT = "MySQL";
    private BackendDBType backendDBType;
    private static ImplementationSwitches obj = null;

    public ImplementationSwitches() throws FatalException {
        String backendDBTypeString = PropertyReader.getProperty(this.BACKEND_DB_TYPE_PROPERTY, BACKEND_DB_TYPE_DEFAULT);
        if (backendDBTypeString.equals("PostGIS")) {
            this.backendDBType = BackendDBType.PostGIS;
        } else if (backendDBTypeString.equals(BACKEND_DB_TYPE_DEFAULT)) {
            this.backendDBType = BackendDBType.MySQL;
        } else {
            throw new FatalException("invalid property value of [" + this.BACKEND_DB_TYPE_PROPERTY + "]," + " value = [" + (Object)((Object)this.backendDBType) + "]," + " expected was [PostGIS] or [MySQL].");
        }
    }

    public boolean getEnableGeometryConversion() {
        return this.enableGeometryConversion;
    }

    public BackendDBType getBackendDBType() {
        return this.backendDBType;
    }

    public boolean isPostGISBackend() {
        return this.backendDBType == BackendDBType.PostGIS;
    }

    public boolean isMySQLBackend() {
        return this.backendDBType == BackendDBType.MySQL;
    }

    public static void createInstance() throws FatalException {
        if (obj == null) {
            obj = new ImplementationSwitches();
        }
    }

    public static ImplementationSwitches instance() {
        return obj;
    }

    public static enum BackendDBType {
        PostGIS,
        MySQL;

    }
}

