/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    private OutputStream tee;
    private boolean closeTee = true;

    public TeeInputStream(InputStream istream, OutputStream teeStream) {
        super(istream);
        this.tee = teeStream;
    }

    public TeeInputStream(InputStream istream, OutputStream teeStream, boolean closeTeeFlag) {
        super(istream);
        this.tee = teeStream;
        this.closeTee = closeTeeFlag;
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (this.tee != null && ret != -1) {
            this.tee.write(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.in.read(b);
        if (this.tee != null && ret != -1) {
            this.tee.write(b, 0, ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        if (this.tee != null && ret != -1) {
            this.tee.write(b, off, ret);
        }
        return ret;
    }

    public void flush() throws IOException {
        if (this.tee != null) {
            this.tee.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.tee != null && this.closeTee) {
            this.tee.close();
        }
    }
}

