/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeName;
import daruma.wfs.TransactionResultInfo;
import daruma.wfs.filter.FilterHandler;
import daruma.xml.SAXExceptionObserver;
import daruma.xml.URI;
import daruma.xml.XMLTag;
import daruma.xml.handler.MispDefaultHandler;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransactionDeleteHandler
extends MispDefaultHandler
implements SAXExceptionObserver {
    private StorageManager storage;
    private SAXExceptionObserver errorReceiver;
    private TransactionResultInfo resultInfo;
    private ElementName specifiedElement;
    private TypeDefinition specifiedElementType;
    private DeleteMode deleteMode;
    private FilterHandler filter;
    private boolean filterTagFound;

    public TransactionDeleteHandler(OutputStream out, XMLReader parser, boolean isTopLevelHandler, StorageManager storage, SAXExceptionObserver errorReceiver, TransactionResultInfo resultInfo) {
        super(out, parser, isTopLevelHandler);
        this.storage = storage;
        this.errorReceiver = errorReceiver;
        this.specifiedElement = null;
        this.specifiedElementType = null;
        this.deleteMode = DeleteMode.PRESERVE;
        this.filter = null;
        this.filterTagFound = false;
        this.resultInfo = resultInfo;
        if (this.resultInfo.countDelete < 0L) {
            this.resultInfo.countDelete = 0L;
        }
    }

    @Override
    public void xStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        assert (super.getCurrentLevel() == 1 || super.getCurrentLevel() == 2);
        XMLTag t = new XMLTag(uri, localName);
        SAXParseException mispNamespaceException = new SAXParseException(t.getLocalName() + " tag " + "should be in namespace " + URI.MISP, super.getLocator());
        if (super.getCurrentLevel() == 1) {
            String typeNameString;
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
                throw mispNamespaceException;
            }
            if (!t.getLocalName().equals("Delete")) {
                this.throwError(new SAXParseException("unknown tag <" + t.getLocalName() + ">.", super.getLocator()));
            }
            if ((typeNameString = attrs.getValue("", "typeName")) == null) {
                this.throwError(new SAXParseException("typeName attribute not found in " + t.getLocalName() + " tag.", super.getLocator()));
            }
            try {
                this.specifiedElement = new ElementName(super.convertQNameStringToUniversalName(typeNameString));
            }
            catch (SAXException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
            }
            TypeName elementTypeName = null;
            try {
                elementTypeName = this.storage.getElementTypeName(this.specifiedElement);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException(e.getMessage(), super.getLocator(), e));
            }
            if (elementTypeName == null) {
                this.throwError(new SAXParseException("element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            try {
                this.specifiedElementType = this.storage.getTypeDefinition(elementTypeName);
            }
            catch (StorageException e) {
                this.throwError(new SAXParseException("type of element " + this.specifiedElement.getLocalName() + " in namespace " + this.specifiedElement.getNamespace() + " not registered", super.getLocator()));
            }
            String deleteModeString = attrs.getValue("", "mode");
            if (deleteModeString != null) {
                if (deleteModeString.equals("preserve")) {
                    this.deleteMode = DeleteMode.PRESERVE;
                } else if (deleteModeString.equals("override")) {
                    this.deleteMode = DeleteMode.OVERRIDE;
                }
                if (deleteModeString.equals("restore")) {
                    this.deleteMode = DeleteMode.RESTORE;
                } else {
                    this.throwError(new SAXParseException("mode attribute of Delele must be one of [preserve|override|restore]", super.getLocator()));
                }
            }
            return;
        }
        if (super.getCurrentLevel() == 2) {
            SAXParseException e;
            if (!t.getURI().equals(URI.MISP)) {
                this.throwError(mispNamespaceException);
                throw mispNamespaceException;
            }
            if (!t.getLocalName().equals("Filter")) {
                e = new SAXParseException("unexpected tag \"" + t.getLocalName() + "\" found, " + "expected was Filter tag.", super.getLocator());
                this.throwError(e);
            }
            if (this.filterTagFound) {
                e = new SAXParseException("Filter multiply specified", super.getLocator());
                this.throwError(e);
            }
            this.filterTagFound = true;
            this.filter = new FilterHandler(super.getOutputStream(), super.getParser(), false, this.specifiedElementType, new TransformationContext(), this.storage, this);
            super.setContentHandlerDelegator(this.filter, uri, localName, qName, attrs);
            return;
        }
    }

    @Override
    public void xEndDocument() throws SAXException {
        if (!this.filterTagFound) {
            this.throwError(new SAXParseException("Filter tag not found", super.getLocator()));
        }
        try {
            int count = 0;
            if (this.deleteMode == DeleteMode.PRESERVE) {
                count = this.storage.deleteElement(this.specifiedElement, this.filter.getPredicate(), this.getTransactionSN(), true);
            } else if (this.deleteMode == DeleteMode.OVERRIDE) {
                count = this.storage.deleteElement(this.specifiedElement, this.filter.getPredicate(), this.getTransactionSN(), false);
            } else if (this.deleteMode == DeleteMode.RESTORE) {
                count = this.storage.restoreElement(this.specifiedElement, this.filter.getPredicate(), this.getTransactionSN());
            }
            this.resultInfo.countDelete += (long)count;
        }
        catch (StorageException e) {
            this.throwError(new SAXParseException(e.getMessage(), super.getLocator()));
        }
    }

    @Override
    public void notifyError(SAXParseException e) throws SAXException {
        this.errorReceiver.notifyError(e);
    }

    public void throwError(SAXParseException e) throws SAXException {
        this.notifyError(e);
        throw e;
    }

    private static enum DeleteMode {
        PRESERVE,
        OVERRIDE,
        RESTORE;

    }
}

