package daruma.util;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.IOException;

/**
 * Input stream that ignore "close()" call
 */
public class CloseIgnoreInputStream extends FilterInputStream
{
	public	CloseIgnoreInputStream( InputStream  i ) {
		super(i);
	}

	/**
	 * Do nothing and leave the stream.
	 */
	public	void	close() throws IOException {
		// do nothing
	}

	/**
	 * Really close the stream
	 */
	public	void	realClose() throws IOException {
		in.close();
	}
}
