package daruma.xml.handler.test;

import daruma.xml.handler.XSAXDefaultHandler;
import daruma.xml.handler.test.sample.SampleErrorHandler;

import org.junit.Test;
import org.junit.Before;
import org.junit.After;
import junit.framework.TestCase;

import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import javax.xml.parsers.SAXParserFactory;


public class XSAXHandlerTest extends TestCase
{
	private	XSAXDefaultHandler	handler = null;


	@Before
	protected	void	setUp() throws Exception
	{
		SAXParserFactory	f = SAXParserFactory.newInstance();
		f.setNamespaceAware( true );

		XMLReader	parser;
		try
		{
			parser = f.newSAXParser().getXMLReader();

			this.handler = new XSAXDefaultHandler
					   ( System.out , parser , true );

			parser.setContentHandler( this.handler );

			parser.setErrorHandler
				( new SampleErrorHandler( System.out ) );
		}
		catch( SAXException  e )
		{
			throw new Exception( "Can't create SAX parser" , e );
		}

		assertNotNull( this.handler );
	}

	@After
	protected	void	tearDown()
	{
		assertNotNull( this.handler );
	}


	@Test
	public	void	testLevel0()
	{
		assertNotNull( this.handler );

		assertEquals( 0 , this.handler.getCurrentLevel() );
	}
}
