package daruma.xml.test;

import daruma.xml.QName;

import org.junit.Test;
import junit.framework.TestCase;

public class QNameTest extends TestCase
{
	@Test
	public	void	testCreate()
	{
		QName	q = new QName( "foo:bar" );

		assertNotNull( q );
	}

	@Test
	public	void	testValues()
	{
		QName	q = new QName( "foo:bar" );

		assertEquals( true , q.isValid() );

		assertEquals( "foo" , q.getPrefix() );
		assertEquals( "bar" , q.getLocalName() );
	}

	@Test
	public	void	testNoPrefix()
	{
		QName	q = new QName( "bar" );

		assertEquals( true , q.isValid() );

		assertEquals( null  , q.getPrefix() );
		assertEquals( "bar" , q.getLocalName() );
	}

	@Test
	public	void	testWhiteSpace()
	{
		QName	q = new QName( "  foo:bar  " );

		assertEquals( true , q.isValid() );
		assertEquals( "foo" , q.getPrefix() );
		assertEquals( "bar" , q.getLocalName() );
	}

	@Test
	public	void	testEmptyString()
	{
		QName	q = new QName( "" );

		assertEquals( false , q.isValid() );
	}

	@Test
	public	void	testNull()
	{
		QName	q = new QName( null );

		assertEquals( false , q.isValid() );
	}

	@Test
	public	void	testSingleColon()
	{
		QName	q = new QName( ":" );

		assertEquals( false , q.isValid() );
	}

	@Test
	public	void	testTooManyColons()
	{
		QName	q = new QName( "foo:bar:baz" );

		assertEquals( false , q.isValid() );
	}

	@Test
	public	void	testEmptyLocalName()
	{
		QName	q = new QName( "foo:" );

		assertEquals( false , q.isValid() );
	}

	@Test
	public	void	testEmptyPrefix()
	{
		QName	q = new QName( ":bar" );

		assertEquals( false , q.isValid() );
	}
}
