/*
 * Decompiled with CFR 0.152.
 */
package daruma.xml.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class PrefixMap {
    private Map<String, String> currentMap = new HashMap<String, String>();
    private Map<String, Stack<String>> stackMap = new HashMap<String, Stack<String>>();

    public Set<Map.Entry<String, String>> entrySet() {
        return this.currentMap.entrySet();
    }

    public Set<String> keySet() {
        return this.currentMap.keySet();
    }

    public String get(String prefix) {
        if (prefix == null) {
            return this.currentMap.get("");
        }
        return this.currentMap.get(prefix);
    }

    public void put(String prefix, String namespaceURI) {
        if (prefix == null) {
            prefix = "";
        }
        this.currentMap.put(prefix, namespaceURI);
        Stack<String> namespaceStack = this.stackMap.get(prefix);
        if (namespaceStack == null) {
            namespaceStack = new Stack();
            namespaceStack.push(namespaceURI);
            this.stackMap.put(prefix, namespaceStack);
        } else {
            namespaceStack.push(namespaceURI);
        }
    }

    public void remove(String prefix) {
        Stack<String> namespaceStack;
        if (prefix == null) {
            prefix = "";
        }
        if ((namespaceStack = this.stackMap.get(prefix)) == null) {
            return;
        }
        namespaceStack.pop();
        if (namespaceStack.empty()) {
            this.currentMap.remove(prefix);
            this.stackMap.remove(prefix);
        } else {
            this.currentMap.put(prefix, namespaceStack.peek());
        }
    }

    public int size() {
        return this.currentMap.size();
    }

    public void clear() {
        this.currentMap.clear();
        this.stackMap.clear();
    }
}

