package daruma.xml.util;

import daruma.xml.URI;

import java.lang.StringBuilder;
import org.xml.sax.Locator;


public class FatalErrorDocument
{
	private	String	message;
	private	Locator	locator;

	public	FatalErrorDocument( String  message ,  Locator  locator )
	{
		this.message = message;
		this.locator = locator;
	}

	public	String	getString()
	{
		StringBuilder	buf = new StringBuilder();

		buf.append( "<FatalError xmlns=\"" + URI.MISP_ERROR + "\"\n" );
		buf.append( "            line = "
			    + "\"" + this.locator.getLineNumber() + "\"" );
		buf.append( "            column = "
			    + "\"" + this.locator.getColumnNumber() + "\"" );
		buf.append( "  <Message>" + this.message + "</Message>\n" );
		buf.append( "</FatalError>\n" );

		return( buf.toString() );
	}
}
