/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmLinearRing;
import daruma.geometry.OgcGeometryFactory;
import daruma.geometry.TransformationException;
import java.util.ArrayList;
import java.util.List;

public class DrmPolygon
extends DrmGeometry {
    private DrmLinearRing outerBoundary;
    private List<DrmLinearRing> innerBoundaries;

    public DrmPolygon() {
        this.outerBoundary = new DrmLinearRing();
        this.innerBoundaries = new ArrayList<DrmLinearRing>();
    }

    public DrmPolygon(DrmLinearRing outerBoundary) {
        this.outerBoundary = outerBoundary;
        this.innerBoundaries = new ArrayList<DrmLinearRing>();
    }

    public void setOuterBoundary(DrmLinearRing linearRing) {
        this.outerBoundary = linearRing;
    }

    public DrmLinearRing getOuterBoundary() {
        return this.outerBoundary;
    }

    public void addInnerBoundary(DrmLinearRing linearRing) {
        this.innerBoundaries.add(linearRing);
    }

    public List<DrmLinearRing> getInnerBoundaries() {
        return this.innerBoundaries;
    }

    @Override
    public DrmPolygon transform(CoordinateSystemTransformation trans) throws TransformationException {
        DrmPolygon ret = new DrmPolygon(this.outerBoundary.transform(trans));
        for (DrmLinearRing ring : this.innerBoundaries) {
            ret.addInnerBoundary(ring.transform(trans));
        }
        return ret;
    }

    public Polygon genGeometry(OgcGeometryFactory geoFactory) {
        DrmLinearRing drmExterior = this.outerBoundary;
        LinearRing exterior = drmExterior.genGeometry(geoFactory);
        return geoFactory.createPolygon(exterior, null);
    }
}

