/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.server.ConnectionInfoHolder;
import daruma.server.DarumaDaemon;
import daruma.util.ISO8601DateFormat;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.PropertyReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Set;

public class DarumaDaemonAdministrator
implements Runnable {
    private final DarumaDaemon daemon;
    private final int adminPort;
    private static final boolean LOCALHOST_ONLY = PropertyReader.getProperty("daruma.serv.admin_port_localhost_only", true);

    DarumaDaemonAdministrator(DarumaDaemon daemon, int adminPort) {
        this.daemon = daemon;
        this.adminPort = adminPort;
    }

    @Override
    public void run() {
        try {
            ServerSocket adminSocket = new ServerSocket(this.adminPort);
            adminSocket.setReuseAddress(true);
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Listen:", adminSocket);
            while (true) {
                Socket adminConnection = adminSocket.accept();
                if (LOCALHOST_ONLY && !adminConnection.getInetAddress().isLoopbackAddress()) {
                    LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "blocked administration connection ", adminConnection, ",", " administration connection", " not allowed except from localhost.");
                    adminConnection.close();
                    continue;
                }
                Thread clientThread = new Thread(new AdminClientHandler(this.daemon, adminConnection));
                clientThread.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    class AdminClientHandler
    implements Runnable {
        DarumaDaemon daemon;
        Socket adminSocket;

        AdminClientHandler(DarumaDaemon daemon, Socket adminSocket) {
            this.daemon = daemon;
            this.adminSocket = adminSocket;
        }

        @Override
        public void run() {
            try {
                String command;
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Open :", this.adminSocket);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.adminSocket.getInputStream()));
                PrintStream out = new PrintStream(this.adminSocket.getOutputStream());
                out.println("type \"help\" to get command list.");
                out.flush();
                while ((command = in.readLine()) != null) {
                    try {
                        if (command.equals("")) continue;
                        if (command.equals("help")) {
                            this.printUsage(out);
                            continue;
                        }
                        if (command.equals("quit")) break;
                        LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "received admin command [", command, "]");
                        if (command.equals("list")) {
                            this.printClientList(out);
                            continue;
                        }
                        if (command.equals("force-disconnect-client")) {
                            this.forceDisconnectClient(out);
                            continue;
                        }
                        LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "admin: no such command");
                        out.println("no such command.");
                        out.println("type \"help\" to get valid command list.");
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Admin Port Close :", this.adminSocket);
                this.adminSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void printUsage(PrintStream out) throws IOException {
            out.println("================================================================");
            out.println(" help                     : print this message");
            out.println(" list                     : get connecting client list");
            out.println(" force-disconnect-client  : disconnect client connection");
            out.println(" quit                     : close this administrator connection");
            out.println("================================================================");
        }

        public ConnectionInfoHolder.DisconnectResult forceDisconnectClient(PrintStream out) throws IOException {
            ConnectionInfoHolder.DisconnectResult result = this.daemon.getConnectionInfoHolder().forceDisconnectClient();
            String message = !result.getSuccess() ? "failed" : (result.getDone() ? "ok, disconnected" : "no client found");
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "admin: ", message);
            out.println(message);
            out.flush();
            return result;
        }

        public void printClientList(PrintStream out) {
            Set<ConnectionInfoHolder.ConnectionInfo> cs = this.daemon.getConnectionInfoHolder().getClientSocketSet();
            for (ConnectionInfoHolder.ConnectionInfo c : cs) {
                String statusString;
                switch (c.getStatus()) {
                    case Running: {
                        statusString = "Running";
                        break;
                    }
                    case Waiting: {
                        statusString = "Waiting";
                        break;
                    }
                    default: {
                        statusString = "Unknown";
                    }
                }
                String connectedDateString = ISO8601DateFormat.getISO8601Instance().format(c.getConnectedDate());
                out.print(c.getConnectionID() + " ");
                out.print(statusString + " ");
                out.print(c.getSocket().getInetAddress().getHostAddress() + ":" + c.getSocket().getPort() + " ");
                out.print(connectedDateString);
                out.println();
            }
            out.println("(" + cs.size() + " client" + (cs.size() != 1 ? "s" : "") + ")");
            out.flush();
        }
    }
}

