/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.TransformationContext;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.wfs.filter.PredicateDescription;
import daruma.xml.Lexicon;
import daruma.xml.util.XMLParseErrorException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImmidiateValueBooleanDescription
extends PredicateDescription {
    private String sqlExpression;

    public static boolean isAcceptablePredicate(String localName) {
        return localName.equals(Lexicon.MispFilterTrue.localname) || localName.equals(Lexicon.MispFilterFalse.localname);
    }

    public ImmidiateValueBooleanDescription(Element element, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, type, trans);
        if (Lexicon.MispFilterTrue.matches(element)) {
            this.tagName = Lexicon.MispFilterTrue;
            this.sqlExpression = "TRUE";
        } else if (Lexicon.MispFilterFalse.matches(element)) {
            this.tagName = Lexicon.MispFilterFalse;
            this.sqlExpression = "FALSE";
        } else {
            throw new XMLParseErrorException("cannot handle filter \"" + element.getTagName() + "\"");
        }
    }

    @Override
    public String getSQLExpression() {
        return this.sqlExpression;
    }

    @Override
    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        return this.tagName != Lexicon.MispFilterFalse;
    }
}

