package daruma.geometry;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.TransformationException;

public abstract class CoordinateSystemTransformation
{
    private String           identifier;
    private CoordinateSystem sourceCS;
    private CoordinateSystem targetCS;
    private long             sourceDimension;
    private long             targetDimension;

    public CoordinateSystemTransformation( String identifier,
					   CoordinateSystem sourceCS,
					   CoordinateSystem targetCS,
					   long sourceDimension,
					   long targetDimension )
    {
	this.identifier = identifier;
	this.sourceCS   = sourceCS;
	this.targetCS   = targetCS;
	this.sourceDimension = sourceDimension;
	this.targetDimension = targetDimension;
    }

    public final String getIdentifier()
    {
	return this.identifier;
    }

    public final CoordinateSystem getSourceCS()
    {
	return this.sourceCS;
    }

    public final CoordinateSystem getTargetCS()
    {
	return this.targetCS;
    }

    public final long getSourceDimension()
    {
	return this.sourceDimension;
    }

    public final long getTargetDimension()
    {
	return this.targetDimension;
    }


    public abstract String getTransformName();

    public abstract String encode();

    public abstract DrmPoint transform( DrmPoint point )
	throws TransformationException;
}
