/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmPoint;
import daruma.geometry.OgcGeometryFactory;
import daruma.geometry.TransformationException;
import java.util.ArrayList;
import java.util.List;

public class DrmMultiPoint
extends DrmGeometry {
    private List<DrmPoint> points = new ArrayList<DrmPoint>();

    public void add(DrmPoint p) {
        this.points.add(p);
    }

    public List<DrmPoint> getPoints() {
        return this.points;
    }

    public DrmPoint get(int indx) {
        return this.points.get(indx);
    }

    @Override
    public DrmMultiPoint transform(CoordinateSystemTransformation trans) throws TransformationException {
        DrmMultiPoint ret = new DrmMultiPoint();
        for (DrmPoint p : this.points) {
            ret.add(trans.transform(p));
        }
        return ret;
    }

    @Override
    public Geometry genGeometry(OgcGeometryFactory geometryFactory) {
        CoordinateSequence coords = geometryFactory.newCoords(this.points.size(), 2);
        int i = 0;
        for (DrmPoint p : this.points) {
            if (p.getDimension() >= 3) {
                OgcGeometryFactory.setCoordinate3D(coords, i, p.getX(), p.getY(), p.getZ());
            } else {
                OgcGeometryFactory.setCoordinate2D(coords, i, p.getX(), p.getY());
            }
            ++i;
        }
        return geometryFactory.createMultiPoint(coords);
    }
}

