/*
 * Decompiled with CFR 0.152.
 */
package daruma.sql;

import daruma.global_switch.ImplementationSwitches;
import daruma.sql.DatabaseCalendarConfig;
import daruma.sql.DatabaseConnectionException;
import daruma.util.LogWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class DatabaseConnection {
    static final boolean DEBUG_DATABASE = false;
    private static final int CONNECTION_MAX_TRIALS = 50;
    private static final int CONNECTION_TRIAL_WAIT_MSEC = 1000;
    private Connection connection = null;
    private String databaseName;
    private String user;
    private String passwd;

    protected abstract String getDatabaseURIPrefix();

    protected abstract String getDatabaseURIPostfix();

    DatabaseConnection() {
    }

    public void setReadOnly(boolean readOnly) throws DatabaseConnectionException {
        LogWriter.qwrite("DEBUG", "set database connection readOnly property to [", readOnly, "]");
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException(e.getMessage(), e);
        }
    }

    public void connect(String databaseName, String user, String passwd) throws DatabaseConnectionException {
        int n;
        this.databaseName = databaseName;
        this.user = user;
        this.passwd = passwd;
        for (n = 1; n < 50; ++n) {
            try {
                String databaseURI = this.getDatabaseURIPrefix() + databaseName;
                String postfix = this.getDatabaseURIPostfix();
                if (postfix != null) {
                    databaseURI = databaseURI + postfix;
                }
                this.connection = DriverManager.getConnection(databaseURI, user, passwd);
                if (ImplementationSwitches.instance().isPostGISBackend()) {
                    this.connection.setAutoCommit(true);
                    break;
                }
                this.connection.setAutoCommit(false);
                break;
            }
            catch (SQLException e) {
                LogWriter.qwrite("WARN", "");
                LogWriter.qwrite("WARN", e.getMessage(), "recconect count = ", n);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                continue;
            }
        }
        if (n > 50) {
            throw new DatabaseConnectionException("connection not established");
        }
        if (n != 1) {
            LogWriter.qwrite("WARN", "connected!!");
        }
    }

    public void close() throws DatabaseConnectionException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException("connection closing failed, sql error [" + e.getMessage() + "]", e);
            }
        }
    }

    public void reset() throws DatabaseConnectionException {
        this.close();
        this.connect(this.databaseName, this.user, this.passwd);
    }

    public void startTransaction() throws DatabaseConnectionException {
        LogWriter.qwrite("DEBUG", "DatabaseConnection::startTransaction");
        if (this.connection == null) {
            throw new DatabaseConnectionException("start transaction failed, connection not established");
        }
    }

    public void commit() throws DatabaseConnectionException {
        LogWriter.qwrite("DEBUG", "DatabaseConnection::commit");
        if (this.connection == null) {
            LogWriter.qwrite("INFO", "commit transaction failed, connection not established");
            throw new DatabaseConnectionException("commit transaction failed, connection not established");
        }
        try {
            this.connection.commit();
            LogWriter.qwrite("DEBUG", "DatabaseConnection::commit", " succeeded");
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("commit failed: " + e.getMessage());
        }
    }

    public void rollback() throws DatabaseConnectionException {
        LogWriter.qwrite("DEBUG", "DatabaseConnection::rollback");
        if (this.connection == null) {
            throw new DatabaseConnectionException("rollback failed, connection not established");
        }
        try {
            LogWriter.qwrite("DEBUG", "DatabaseConnection::rollback");
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("rollback failed: " + e.getMessage());
        }
    }

    public Date getCurrentTime() throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("can't get current time, connection is not established yet");
        }
        Statement s = null;
        try {
            s = this.connection.createStatement();
            ResultSet r = s.executeQuery("SELECT NOW()");
            Timestamp ret = null;
            if (!r.next()) {
                throw new DatabaseConnectionException("can't get current time, unexpected database response");
            }
            ret = r.getTimestamp(1);
            if (r.next()) {
                throw new DatabaseConnectionException("can't get current time, unexpected database response");
            }
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("can't get current time, sql error [" + e.getMessage() + "]", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("connection closing failed, sql error [" + e.getMessage() + "]", e);
                }
            }
        }
    }

    public PreparedStatement prepareStatement(String sqlString) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("prepared statement failed, connection not established");
        }
        try {
            LogWriter.qwrite("DEBUG", "DatabaseConnection::prepareStatement: " + sqlString);
            return this.connection.prepareStatement(sqlString);
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "prepareStatement failed [", e.getMessage(), "]");
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage());
            }
            throw new DatabaseConnectionException("prepaerd statement failed: " + e.getMessage(), e);
        }
    }

    public QueryResult executeQuery(String sqlString) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("query failed, connection not established");
        }
        Statement s = null;
        try {
            this.startDebugLog(sqlString);
            s = this.connection.createStatement();
            long startTime = System.currentTimeMillis();
            ResultSet r = s.executeQuery(sqlString);
            long endTime = System.currentTimeMillis();
            this.writeDebugLog(sqlString, startTime, endTime);
            return new QueryResult(r, s);
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "query failed [", e.getMessage(), "]");
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage());
            }
            throw new DatabaseConnectionException("query failed: " + e.getMessage(), e);
        }
    }

    public QueryResult executeQuery(PreparedStatement statement) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("query failed, connection not established");
        }
        try {
            long startTime = System.currentTimeMillis();
            ResultSet r = statement.executeQuery();
            long endTime = System.currentTimeMillis();
            this.writeDebugLog(statement, startTime, endTime);
            return new QueryResult(r, statement);
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "query failed [", e.getMessage(), "]");
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage());
            }
            throw new DatabaseConnectionException("query failed: " + e.getMessage(), e);
        }
    }

    public int executeUpdate(String sqlString) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("connection not established");
        }
        Statement s = null;
        try {
            s = this.connection.createStatement();
            this.startDebugLog(sqlString);
            long startTime = System.currentTimeMillis();
            int count = s.executeUpdate(sqlString);
            long endTime = System.currentTimeMillis();
            this.writeDebugLog(sqlString, startTime, endTime);
            int n = count;
            return n;
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "update failed [", e.getMessage(), "]");
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage());
            }
            throw new DatabaseConnectionException("update failed: " + e.getMessage(), e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("statement can't close", e);
                }
            }
        }
    }

    public int executeUpdate(PreparedStatement statement) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("connection not established");
        }
        try {
            this.startDebugLog(statement);
            long startTime = System.currentTimeMillis();
            int count = statement.executeUpdate();
            long endTime = System.currentTimeMillis();
            this.writeDebugLog(statement, startTime, endTime);
            int n = count;
            return n;
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "update failed [", e.getMessage(), "]");
            if (e.getNextException() != null) {
                LogWriter.qwrite("DEBUG", "detailed exception is [", e.getNextException().getMessage());
            }
            throw new DatabaseConnectionException("update failed: " + e.getMessage(), e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("statement can't close", e);
                }
            }
        }
    }

    public void dropAllTables() throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("can't drop all tables because connection is not established yet");
        }
        Statement s = null;
        ResultSet r = null;
        try {
            s = this.connection.createStatement();
            r = s.executeQuery("SHOW TABLES");
            while (r.next()) {
                Statement d = null;
                try {
                    d = this.connection.createStatement();
                    String sql = "DROP TABLE IF EXISTS " + r.getString(1);
                    this.startDebugLog(sql);
                    d.executeUpdate("DROP TABLE IF EXISTS " + r.getString(1));
                    d.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("`drop table' failed", e);
                }
                finally {
                    if (d == null) continue;
                    try {
                        d.close();
                    }
                    catch (SQLException e) {
                        throw new DatabaseConnectionException("statement can't close", e);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("`drop all tables' failed", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("statement can't close", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableIfExists(String tableName) throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("can't drop table [" + tableName + "]" + " because connection is not established yet");
        }
        Statement d = null;
        try {
            d = this.connection.createStatement();
            String sql = "DROP TABLE " + tableName;
            this.startDebugLog(sql);
            d.executeUpdate(sql);
        }
        catch (SQLException e) {
            LogWriter.qwrite("DEBUG", "DatabaseConnection:dropTableIfExists: drop failed, ignored");
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("statement can't close", e);
                }
            }
        }
    }

    public List<String> showTables() throws DatabaseConnectionException {
        if (this.connection == null) {
            throw new DatabaseConnectionException("can't show tables because connection is not established yet");
        }
        ArrayList<String> ret = new ArrayList<String>();
        Statement s = null;
        try {
            s = this.connection.createStatement();
            ResultSet r = s.executeQuery("SHOW TABLES");
            while (r.next()) {
                ret.add(r.getString(1));
            }
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("show tables failed", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("can't close statement", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLongValueFromTable(String tableName, String columnName) throws DatabaseConnectionException {
        QueryResult r = null;
        try {
            r = this.executeQuery("SELECT MAX(" + columnName + ")" + " FROM " + tableName + "");
            long l = r.getSingleLongValue(1);
            return l;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSingleLongValueFromPreparedStatement(PreparedStatement statement, int column) throws DatabaseConnectionException {
        QueryResult r = null;
        try {
            r = this.executeQuery(statement);
            long l = r.getSingleLongValue(1);
            return l;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private void startDebugLog(PreparedStatement statement) {
        LogWriter.qwrite("DEBUG", "#", statement);
        LogWriter.qwrite("DEBUG", "free/max memory = ", Runtime.getRuntime().freeMemory(), "/", Runtime.getRuntime().maxMemory());
    }

    private void startDebugLog(String sqlString) {
        LogWriter.qwrite("DEBUG", "#", sqlString);
        LogWriter.qwrite("DEBUG", "free/max memory = ", Runtime.getRuntime().freeMemory(), "/", Runtime.getRuntime().maxMemory());
    }

    private void writeDebugLog(PreparedStatement statement) {
        LogWriter.qwrite("DEBUG", "#", statement);
        LogWriter.qwrite("DEBUG", "free/max memory = ", Runtime.getRuntime().freeMemory(), "/", Runtime.getRuntime().maxMemory());
    }

    private void writeDebugLog(PreparedStatement statement, long startTime, long endTime) {
        String debugLevel = "DEBUG";
        LogWriter.qwrite(debugLevel, "! ", endTime - startTime, " msec", "\t", Character.valueOf('#'), statement);
    }

    private void writeDebugLog(String sqlString, long startTime, long endTime) {
        String debugLevel = "DEBUG";
        LogWriter.qwrite(debugLevel, "! ", endTime - startTime, " msec", "\t", Character.valueOf('#'), sqlString);
    }

    public static class QueryResult {
        private ResultSet resultSet;
        private Statement statement;

        public QueryResult(ResultSet resultSet, Statement statement) {
            this.resultSet = resultSet;
            this.statement = statement;
        }

        public boolean next() throws DatabaseConnectionException {
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        private String bytesToString(byte[] rawBytes) throws DatabaseConnectionException {
            if (rawBytes == null) {
                return null;
            }
            try {
                return new String(rawBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public String getString(int columnIndex) throws DatabaseConnectionException {
            byte[] rawBytes;
            try {
                rawBytes = this.resultSet.getBytes(columnIndex);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
            return this.bytesToString(rawBytes);
        }

        public String getString(String columnName) throws DatabaseConnectionException {
            byte[] rawBytes;
            try {
                rawBytes = this.resultSet.getBytes(columnName);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
            return this.bytesToString(rawBytes);
        }

        public Long getLong(int columnIndex) throws DatabaseConnectionException {
            try {
                return this.resultSet.getLong(columnIndex);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Long getLong(String columnName) throws DatabaseConnectionException {
            try {
                return this.resultSet.getLong(columnName);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Integer getInt(int columnIndex) throws DatabaseConnectionException {
            try {
                return this.resultSet.getInt(columnIndex);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Integer getInt(String columnName) throws DatabaseConnectionException {
            try {
                return this.resultSet.getInt(columnName);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Timestamp getTimestamp(int columnIndex) throws DatabaseConnectionException {
            try {
                return this.resultSet.getTimestamp(columnIndex, DatabaseCalendarConfig.getCalendar());
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Timestamp getTimestamp(String columnName) throws DatabaseConnectionException {
            try {
                return this.resultSet.getTimestamp(columnName, DatabaseCalendarConfig.getCalendar());
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws DatabaseConnectionException {
            try {
                return this.resultSet.getTimestamp(columnIndex, cal);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Timestamp getTimestamp(String columnName, Calendar cal) throws DatabaseConnectionException {
            try {
                return this.resultSet.getTimestamp(columnName, cal);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Blob getBlob(int columnIndex) throws DatabaseConnectionException {
            try {
                return this.resultSet.getBlob(columnIndex);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public Blob getBlob(String columnName) throws DatabaseConnectionException {
            try {
                return this.resultSet.getBlob(columnName);
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e.getMessage(), e);
            }
        }

        public void close() throws DatabaseConnectionException {
            if (this.statement != null) {
                try {
                    this.resultSet.close();
                    this.statement.close();
                }
                catch (SQLException e) {
                    throw new DatabaseConnectionException("statement can't close", e);
                }
            }
        }

        public long getSingleLongValue(int columnIndex) throws DatabaseConnectionException {
            boolean found = false;
            long value = 0L;
            try {
                while (this.resultSet.next()) {
                    if (found) {
                        throw new DatabaseConnectionException("found multiple data in column " + columnIndex);
                    }
                    found = true;
                    value = this.resultSet.getLong(columnIndex);
                }
            }
            catch (SQLException e) {
                throw new DatabaseConnectionException(e);
            }
            if (!found) {
                throw new DatabaseConnectionException("data not found in column " + columnIndex);
            }
            return value;
        }
    }
}

