/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.sql.SQLDataType;
import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.xml.util.WhitespaceProceccer;

public class BooleanTypeDefinition
extends AbstractSingleTypeDefinition {
    @Override
    public SQLDataType getSingleSQLDataType() {
        return new SQLDataType("boolean", Boolean.class);
    }

    @Override
    public String parseValue(String value) throws TypeException {
        String v = WhitespaceProceccer.cutoffEdgeWhitespaces(value);
        if (!(v.equals("true") || v.equals("false") || v.equals("0") || v.equals("1"))) {
            if (v.equalsIgnoreCase("TRUE") || v.equalsIgnoreCase("FALSE")) {
                throw new TypeException("\"" + v + "\" is not a valid boolean value," + " use lowercase word" + " \"true\" or \"false\"");
            }
            throw new TypeException("\"" + v + "\" is not a valid boolean value");
        }
        return v;
    }
}

