/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountInputStream
extends FilterInputStream {
    private long byteCount = 0L;
    private long markedPoint = 0L;

    public CountInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret != -1) {
            ++this.byteCount;
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.in.read(b);
        if (ret != -1) {
            this.byteCount += (long)ret;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        if (ret != -1) {
            this.byteCount += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = this.in.skip(n);
        this.byteCount += ret;
        return ret;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedPoint = this.byteCount;
    }

    @Override
    public void reset() throws IOException {
        this.byteCount = this.markedPoint;
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

