package daruma.sql;

import daruma.sql.TableColumnDefinition;
import daruma.sql.Separators;

import java.lang.StringBuilder;
import java.util.List;
import java.util.ArrayList;

public class TableDefinition
{
	private static final boolean	ALL_INDEXED = false;

	private	List<TableColumnDefinition>	columns;

	public	TableDefinition( List<TableColumnDefinition>  columns )
	{
		this.columns = columns;
	}

	public	String	getTableDefinitionString()
	{
		StringBuilder	s = new StringBuilder();

		for ( TableColumnDefinition  c : columns )
		{
			if ( s.length() != 0 )
			{
				s.append( ", " );
			}

			SQLDataType	t = c.getSQLDataType();

			s.append( c.getColumnName() );
			s.append( " " );
			s.append( t.getSQLBaseDataTypeString() );

			if ( TableDefinition.ALL_INDEXED )
			{
				s.append( ", " );
				s.append( t.getIndexString
					  ( c.getColumnName() ) );
			}
		}

		return( s.toString() );
	}

	public	String	getCommaSeparatedColumnNamesForRawSQLString()
	{
		StringBuilder	s = new StringBuilder();

		for ( TableColumnDefinition  c : columns )
		{
			if ( s.length() != 0 )
			{
				s.append( "," );
			}

			s.append
			  ( c.getSQLDataType()
				.getSQLRetrieveColumnStringForRawSQLString
				    ( c.getColumnName() ) );
		}

		return( s.toString() );
	}


	public	List<String>	getSubTables( String  tableName )
	{
		List<String>	ret = new ArrayList<String>();

		for ( TableColumnDefinition  c : columns )
		{
			if ( c.isExternalTable() )
			{
				ret.add( tableName
					 + Separators.PATH_SEPARATOR
					 + c.getColumnName() );
			}
		}

		return( ret );
	}
}
