/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.schema.AnnotationElementChecker;
import daruma.storage_manager.type_definition.AbstractCompositorTypeDefinition;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.XMLSchemaElementDefinition;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTypeDefinition
extends AbstractCompositorTypeDefinition {
    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex) throws TypeException {
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", "");
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": createInstance()");
        LogWriter.qwrite("DEBUG", "elementIndex = ", elementIndex);
        LogWriter.qwrite("DEBUG", "--");
        this.debugPrint();
        LogWriter.qwrite("DEBUG", "--");
        LogWriter.qwrite("DEBUG", element);
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
        NodeList childNodes = element.getChildNodes();
        int nThChildNode = elementIndex;
        for (AbstractCompositorTypeDefinition.Entry entry : super.getEntries()) {
            String debugString = "next entry = ";
            debugString = entry.isCompositeEntry() ? debugString + "composite, " + entry.getCompositeEntry().getClass().getName() : debugString + "atomic";
            LogWriter.qwrite("DEBUG", debugString);
            if (entry.isCompositeEntry()) {
                Pair<TypedInstance, Integer> r = entry.getCompositeEntry().createInstance(element, topLevelElement, path, storage, nThChildNode);
                columnList.addAll(r.getFirst().getColumns());
                LogWriter.qwrite("DEBUG", "nThChildNode updated from ", nThChildNode, " to ", r.getSecond());
                nThChildNode = r.getSecond();
                continue;
            }
            Node n = null;
            XMLSchemaElementDefinition elementDefinition = entry.getAtomEntry();
            ElementName expectedElementName = elementDefinition.getElementName();
            long minOccurs = elementDefinition.getMinOccurs();
            Element childElement = null;
            ElementName childElementName = null;
            while (true) {
                if (nThChildNode >= childNodes.getLength()) {
                    LogWriter.qwrite("DEBUG", "child index = ", nThChildNode, ", number of child nodes = ", childNodes.getLength());
                    if (minOccurs == 0L) break;
                    throw new TypeException("too few child elements of " + new ElementName(element).toString());
                }
                n = childNodes.item(nThChildNode);
                if (n instanceof Element && !AnnotationElementChecker.isXMLSchemaAnnotationElement((Element)n)) {
                    childElement = (Element)n;
                    childElementName = new ElementName(childElement);
                    break;
                }
                ++nThChildNode;
            }
            LogWriter.qwrite("DEBUG", "tag[", nThChildNode, "] = [", childElementName == null ? "null" : childElementName, "]");
            LogWriter.qwrite("DEBUG", "expected element = [", expectedElementName, "], minOccurs = ", minOccurs);
            boolean dataExists = true;
            if (childElementName == null || !childElementName.equals(expectedElementName)) {
                LogWriter.qwrite("DEBUG", "unmached");
                if (minOccurs != 0L) {
                    throw new TypeException("unexpected element \"" + childElementName + "\", expected was " + expectedElementName);
                }
                dataExists = false;
            }
            TypeDefinition type = elementDefinition.getType();
            SimpleXPath p = new SimpleXPath(path);
            if (path != null) {
                p.add(new UniversalName(element));
            }
            if (dataExists) {
                TypedInstance obj = type.createInstance(childElement, topLevelElement, p, storage, 0).getFirst();
                columnList.addAll(obj.getColumns());
            } else {
                p.add(expectedElementName);
                List<TableColumnDefinition> columnDefs = type.getCompositeSQLDataType(storage, p);
                if (columnDefs == null) {
                    String columnName;
                    try {
                        columnName = storage.getShortXPathStringForDB(p);
                    }
                    catch (StorageException e) {
                        throw new TypeException(e.getMessage(), e);
                    }
                    TableColumn tc = new TableColumn(new TableColumnDefinition(columnName, type.getSingleSQLDataType()), null);
                    tc.setIsEmptyColumn(true);
                    columnList.add(tc);
                } else {
                    for (TableColumnDefinition c : columnDefs) {
                        TableColumn tc = new TableColumn(c, null);
                        tc.setIsEmptyColumn(true);
                        columnList.add(tc);
                    }
                }
            }
            if (dataExists) {
                ++nThChildNode;
            }
            LogWriter.qwrite("DEBUG", "");
            LogWriter.qwrite("DEBUG", "");
        }
        return new Pair<TypedInstance, Integer>(new TypedInstance(columnList, this), nThChildNode);
    }
}

