/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter.predicates;

import daruma.geometry.DrmGeometry;
import daruma.geometry.GeometryException;
import daruma.geometry.GeometryFormatConverter;
import daruma.geometry.TransformationContext;
import daruma.global_switch.ImplementationSwitches;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.types.GeometryPropertyTypeDefinition;
import daruma.util.LogWriter;
import daruma.wfs.filter.PredicateDescription;
import daruma.wfs.filter.PropertyPathConverter;
import daruma.xml.DeclaredName;
import daruma.xml.Lexicon;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeometryPredicateDescription
extends PredicateDescription {
    private String sqlFunction;
    private String sqlExpression;
    public String propertyXPath;
    public Element xpathContext;
    public DrmGeometry geometry;
    private static DeclaredName.Table<String> operatorTable = new DeclaredName.Table();

    public static boolean isAcceptablePredicate(String localName) {
        return operatorTable.getEntryByLocalName(localName) != null;
    }

    public GeometryPredicateDescription(Element element, TypeDefinition type, TransformationContext trans, StorageManager storage) throws XMLParseErrorException {
        super(storage, type, trans);
        DeclaredName.Table.Entry entry = operatorTable.getEntry(element);
        this.sqlFunction = (String)entry.getValue();
        this.tagName = entry.getName();
        if (this.sqlFunction == null) {
            throw new XMLParseErrorException("cannot handle filter \"" + element.getLocalName() + "\"");
        }
        this.sqlExpression = this.parseGeometryPropertyComparation(element);
    }

    public String getSQLExpression() {
        return this.sqlExpression;
    }

    private String parseGeometryPropertyComparation(Element comp) throws XMLParseErrorException {
        String baseSQL;
        List<Element> childElements = ElementUtil.getChildElements(comp);
        if (childElements.size() != 2) {
            throw new XMLParseErrorException("filter \"" + comp.getLocalName() + "\"" + " has invalid number of child elements," + " expected was 2");
        }
        Element propertyNameElement = childElements.get(0);
        Element geometryElement = childElements.get(1);
        Lexicon.MispPropertyName.matchesOrXmlException(propertyNameElement, "in GeometryPredicates");
        String shortXPath = PropertyPathConverter.convertPropertyElementToShortXPath(propertyNameElement, this.getStorage());
        this.propertyXPath = ElementUtil.getChildNodesWholeText(propertyNameElement);
        this.xpathContext = propertyNameElement;
        try {
            this.geometry = GeometryFormatConverter.parseFromGMLElement(geometryElement);
        }
        catch (GeometryException e) {
            throw new XMLParseErrorException("geometry parse error", e);
        }
        String wktString = GeometryFormatConverter.convertGeometryToWKTString(this.geometry, true, true);
        if (wktString == null) {
            wktString = "NULL";
        }
        String querySQL = baseSQL = this.sqlFunction + "(" + GeometryPropertyTypeDefinition.convertShortXPathToColumnName(shortXPath) + ",GeomFromText('" + wktString + "'))";
        if (ImplementationSwitches.instance().getEnableGeometryConversion()) {
            TransformationContext trans = super.getTransformationContext();
            switch (trans.getTransformationType()) {
                case Selective: {
                    if (trans.getTargetCoordinateSystem() == null) {
                        throw new XMLParseErrorException("srsName not specified");
                    }
                    querySQL = "(" + baseSQL + ") AND " + GeometryPropertyTypeDefinition.convertShortXPathToSrsColumnName(shortXPath) + " = '" + trans.getTargetCoordinateSystem().getSrsName() + "'";
                    LogWriter.qwrite("DEBUG", "Query = [", querySQL, "]");
                    break;
                }
                case Conv: {
                    break;
                }
            }
        }
        return querySQL;
    }

    public boolean detailedCheck(Node feature) throws XMLParseErrorException {
        try {
            XMLFormatConverter.print(feature, System.err);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean result = false;
        try {
            Element propNode = (Element)XPathAPI.selectSingleNode((Node)feature, (String)this.propertyXPath, (Node)this.xpathContext);
            Element geoNode = ElementUtil.getSingleChildElement(propNode);
            DrmGeometry drmGeo = GeometryFormatConverter.parseFromGMLElement(geoNode);
            if (this.tagName == Lexicon.MispFilterBBOX || this.tagName == Lexicon.MispFilterBBox) {
                result = drmGeo.intersects(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterContains) {
                result = drmGeo.contains(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterCrosses) {
                result = drmGeo.crosses(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterDisjoint) {
                result = drmGeo.disjoint(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterEquals) {
                result = drmGeo.equals(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterIntersects) {
                result = drmGeo.intersects(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterOverlaps) {
                result = drmGeo.overlaps(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterTouches) {
                result = drmGeo.touches(this.geometry);
            } else if (this.tagName == Lexicon.MispFilterWithin) {
                result = drmGeo.within(this.geometry);
            }
        }
        catch (TransformerException ex) {
            throw new XMLParseErrorException("property '" + this.propertyXPath + "'" + " is not found in " + feature, ex);
        }
        catch (GeometryException ex) {
            throw new XMLParseErrorException("property '" + this.propertyXPath + "'" + " is not found in " + feature, ex);
        }
        return result;
    }

    static {
        switch (ImplementationSwitches.instance().getBackendDBType()) {
            case PostGIS: {
                operatorTable.put(Lexicon.MispFilterBBOX, "ST_Intersects");
                operatorTable.put(Lexicon.MispFilterBBox, "ST_Intersects");
                break;
            }
            case MySQL: {
                operatorTable.put(Lexicon.MispFilterBBOX, "MBRIntersects");
                operatorTable.put(Lexicon.MispFilterBBox, "MBRIntersects");
            }
        }
        operatorTable.put(Lexicon.MispFilterContains, "CONTAINS");
        operatorTable.put(Lexicon.MispFilterCrosses, "CROSSES");
        operatorTable.put(Lexicon.MispFilterDisjoint, "DISJOINT");
        operatorTable.put(Lexicon.MispFilterEquals, "EQUALS");
        operatorTable.put(Lexicon.MispFilterIntersects, "INTERSECTS");
        operatorTable.put(Lexicon.MispFilterOverlaps, "OVERLAPS");
        operatorTable.put(Lexicon.MispFilterTouches, "TOUCHES");
        operatorTable.put(Lexicon.MispFilterWithin, "WITHIN");
    }
}

