/*
 * Decompiled with CFR 0.152.
 */
package daruma.geometry;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.util.Pair;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateSystemTransformationDictionary {
    private Map<Pair<CoordinateSystem, CoordinateSystem>, CoordinateSystemTransformation> transMap = new HashMap<Pair<CoordinateSystem, CoordinateSystem>, CoordinateSystemTransformation>();
    private Map<CoordinateSystem, Map<CoordinateSystem, CoordinateSystemTransformation>> targetMap = new HashMap<CoordinateSystem, Map<CoordinateSystem, CoordinateSystemTransformation>>();
    private Map<CoordinateSystem, Map<CoordinateSystem, CoordinateSystemTransformation>> sourceMap = new HashMap<CoordinateSystem, Map<CoordinateSystem, CoordinateSystemTransformation>>();

    public void put(CoordinateSystemTransformation trans) {
        CoordinateSystem sourceCS = trans.getSourceCS();
        CoordinateSystem targetCS = trans.getTargetCS();
        this.transMap.put(new Pair<CoordinateSystem, CoordinateSystem>(sourceCS, targetCS), trans);
        Map<CoordinateSystem, CoordinateSystemTransformation> t = this.targetMap.get(targetCS);
        if (t == null) {
            t = new HashMap<CoordinateSystem, CoordinateSystemTransformation>();
            this.targetMap.put(targetCS, t);
        }
        t.put(sourceCS, trans);
        Map<CoordinateSystem, CoordinateSystemTransformation> s = this.sourceMap.get(sourceCS);
        if (s == null) {
            s = new HashMap<CoordinateSystem, CoordinateSystemTransformation>();
            this.sourceMap.put(sourceCS, s);
        }
        s.put(targetCS, trans);
    }

    public CoordinateSystemTransformation get(CoordinateSystem sourceCS, CoordinateSystem targetCS) {
        return this.transMap.get(new Pair<CoordinateSystem, CoordinateSystem>(sourceCS, targetCS));
    }

    public Map<CoordinateSystem, CoordinateSystemTransformation> getTransTo(CoordinateSystem targetCS) {
        return this.targetMap.get(targetCS);
    }

    public Map<CoordinateSystem, CoordinateSystemTransformation> getTransFrom(CoordinateSystem sourceCS) {
        return this.sourceMap.get(sourceCS);
    }

    public CoordinateSystemTransformation remove(CoordinateSystemTransformation trans) {
        CoordinateSystem targetCS;
        CoordinateSystem sourceCS = trans.getSourceCS();
        CoordinateSystemTransformation removed = this.transMap.remove(new Pair<CoordinateSystem, CoordinateSystem>(sourceCS, targetCS = trans.getTargetCS()));
        if (removed != null) {
            return removed;
        }
        Map<CoordinateSystem, CoordinateSystemTransformation> s = this.sourceMap.get(sourceCS);
        assert (s != null);
        s.remove(targetCS);
        if (s.isEmpty()) {
            this.sourceMap.remove(sourceCS);
        }
        Map<CoordinateSystem, CoordinateSystemTransformation> t = this.targetMap.get(targetCS);
        assert (t != null);
        t.remove(sourceCS);
        if (t.isEmpty()) {
            this.targetMap.remove(targetCS);
        }
        return removed;
    }

    public CoordinateSystemTransformationDictionary clone() {
        CoordinateSystemTransformationDictionary ret = new CoordinateSystemTransformationDictionary();
        for (CoordinateSystemTransformation trans : this.transMap.values()) {
            ret.put(trans);
        }
        return ret;
    }

    public void debugPrint(PrintStream out) {
        CoordinateSystemTransformationDictionary ret = new CoordinateSystemTransformationDictionary();
        for (CoordinateSystemTransformation coordinateSystemTransformation : this.transMap.values()) {
            out.println("[" + coordinateSystemTransformation.getSourceCS().getSrsName() + "] -> " + "[" + coordinateSystemTransformation.getTargetCS().getSrsName() + "]");
        }
        for (Map.Entry entry : this.sourceMap.entrySet()) {
            out.println("sourceMap[" + ((CoordinateSystem)entry.getKey()).getSrsName() + "]");
            for (CoordinateSystem t : ((Map)entry.getValue()).keySet()) {
                out.println(" -> [" + t.getSrsName() + "]");
            }
        }
        for (Map.Entry entry : this.targetMap.entrySet()) {
            out.println("targetMap[" + ((CoordinateSystem)entry.getKey()).getSrsName() + "]");
            for (CoordinateSystem s : ((Map)entry.getValue()).keySet()) {
                out.println(" <- [" + s.getSrsName() + "]");
            }
        }
    }
}

