/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager;

import daruma.geometry.AffineCoordinateSystemTransformation;
import daruma.geometry.CoordinateSystem;
import daruma.geometry.CoordinateSystemTransformation;
import daruma.geometry.CoordinateSystemTransformationDictionary;
import daruma.geometry.DrmEnvelope;
import daruma.geometry.TransformationContext;
import daruma.global_switch.ImplementationSwitches;
import daruma.sql.DatabaseConnection;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.ElementInserter;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.sql.TableDefinition;
import daruma.storage_manager.BulkInsertBuffer;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.TypeDictionary;
import daruma.storage_manager.schema.XMLSchemaParseAndRegister;
import daruma.storage_manager.schema.XMLSchemaParserException;
import daruma.storage_manager.schema.XMLSchemaSet;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypeName;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.storage_manager.type_definition.TypedInstanceSet;
import daruma.storage_manager.type_definition.types.GeometryPropertyTypeDefinition;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.util.ParseException;
import daruma.util.PropertyReader;
import daruma.util.StringSplitter;
import daruma.util.TextUtil;
import daruma.wfs.filter.PredicateDescription;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import daruma.xml.util.PrefixMap;
import daruma.xml.util.XMLFormatConverter;
import java.io.ByteArrayOutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMSStorageManager
extends StorageManager {
    public static final String SCHEMA_TABLE_NAME = "__schema__";
    public static final String COORD_TRANS_TABLE_NAME = "__coord_trans__";
    public static final String ColName_SchemaTabSchemaID = "schema_id";
    public static final String ColName_SchemaTabInternalSchemaID = "internal_schema_id";
    public static final String ColName_SchemaTabTargetNamespace = "target_namespace";
    public static final String ColName_SchemaTabSchemaDef = "schema_definition";
    public static final String ColName_SchemaTabTimeStamp = "timestamp";
    public static final String ELEMENT_TABLE_NAME = "__element__";
    public static final String ColName_ElementTabElementNS = "element_namespace";
    public static final String ColName_ElementTabElementName = "element_name";
    public static final String ColName_ElementTabElementInternalSchemaID = "element_internal_schema_id";
    public static final String ColName_ElementTabTypeNS = "type_namespace";
    public static final String ColName_ElementTabTypeName = "type_name";
    public static final String ColName_ElementTabTypeInternalSchemaID = "type_internal_schema_id";
    public static final String ColName_ElementTabDeleted = "deleted";
    public static final String ColName_ElementTabTimeStamp = "timestamp";
    public static final String TYPE_TABLE_NAME = "__type__";
    public static final String ColName_TypeTabTypeNS = "type_namespace";
    public static final String ColName_TypeTabTypeName = "type_name";
    public static final String ColName_TypeTabSchemaURI = "schema_uri";
    public static final String ColName_TypeTabInternalSchemaID = "internal_schema_id";
    public static final String ColName_TypeTabTimeStamp = "timestamp";
    public static final String ColName_TypeTabDeleted = "deleted";
    public static final String UNIVERSAL_NAME_ALIAS_TABLE_NAME = "__universal_name_alias__";
    public static final String ColName_UNameTabNameSpace = "namespace";
    public static final String ColName_UNameTabLocalName = "local_name";
    public static final String ColName_UNameTabSerialNum = "id_number";
    public static final String ColName_UNameTabId = "id";
    public static final String ColName_UNameTabAlias = "alias";
    public static final String TRANSACTION_LOG_TABLE_NAME = "__transaction_log__";
    public static final String ColName_TransTabSerialNum = "id";
    public static final String ColName_TransTabURI = "uri";
    public static final String ColName_TransTabTimeStamp = "timestamp";
    public static final String ColName_TransTabFrom = "request_from";
    public static final String ColName_TransTabType = "type";
    public static final String ColName_TransTabInfo = "info";
    public static final String ColName_CoordTransID = "id";
    public static final String ColName_CoordTransSource = "source_coord";
    public static final String ColName_CoordTransTarget = "target_coord";
    public static final String ColName_CoordTransSourceDim = "source_dimension";
    public static final String ColName_CoordTransTargetDim = "target_dimension";
    public static final String ColName_CoordTransTargetMethod = "method";
    public static final String ColName_CoordTransValue = "value";
    public static final String ColName_CoordTransDeleted = "deleted";
    public static final String ColName_SystemID = "_id_";
    public static final String ColName_SystemParentID = "_parent_id_";
    public static final String ColName_SystemTransactionID = "_transaction_id_";
    public static final String ColName_SystemCreateTime = "_create_time_";
    public static final String ColName_SystemUpdateTime = "_update_time_";
    public static final String ColName_SystemDeleted = "_deleted_";
    public static final String DEFAULT_SET_NAME = "_s";
    static final String UNameIdPrefix = "id";
    private DatabaseConnection db;
    private static TypeDictionary typeDictionaryCache = new TypeDictionary();
    private Map<ElementName, TypeName> elementDictionaryCache;
    private Map<UniversalName, String> universalNameDictionaryCache;
    private static final String MYSQL_ENGINE = "daruma.mysql.engine";
    private static final String MYSQL_ENCODING = "daruma.mysql.default_encoding";
    private static CoordinateSystemTransformationDictionary coordTransDictionary = null;

    private String get_engine_string() {
        if (ImplementationSwitches.instance().isMySQLBackend()) {
            String engine = PropertyReader.getProperty(MYSQL_ENGINE, "");
            if (engine.length() == 0) {
                return null;
            }
            return "ENGINE=" + engine;
        }
        return null;
    }

    private String get_encoding_string() {
        if (ImplementationSwitches.instance().isMySQLBackend()) {
            String encoding = PropertyReader.getProperty(MYSQL_ENCODING, "");
            if (encoding.length() == 0) {
                return null;
            }
            return "DEFAULT CHARSET=" + encoding;
        }
        return null;
    }

    public DBMSStorageManager(DatabaseConnection db) {
        assert (db != null);
        this.db = db;
        this.elementDictionaryCache = new HashMap<ElementName, TypeName>();
        this.universalNameDictionaryCache = new HashMap<UniversalName, String>();
    }

    private void initializeStorage() throws DatabaseConnectionException {
        try {
            this.registerUniversalNameIfNotRegistrated(new UniversalName(null, "srsName"));
            this.updateCoordTransDictionary();
        }
        catch (StorageException e) {
            throw new DatabaseConnectionException(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws StorageException {
        try {
            this.db.setReadOnly(readOnly);
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public void startTransaction() throws StorageException {
        try {
            this.db.startTransaction();
        }
        catch (DatabaseConnectionException e) {
            e.printStackTrace();
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public void commit() throws StorageException {
        try {
            this.db.commit();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public void rollback() throws StorageException {
        try {
            this.db.rollback();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    public void connect(String databaseName, String user, String passwd) throws DatabaseConnectionException {
        this.db.connect(databaseName, user, passwd);
        this.initializeStorage();
    }

    public void close() throws DatabaseConnectionException {
        this.db.close();
    }

    @Override
    public void reset() throws StorageException {
        try {
            this.db.reset();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public void registerSchema(Element schema, PrefixMap prefixMap) throws StorageException {
        long internalSchemaID;
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": ", "registerSchema");
        try {
            internalSchemaID = this.db.getMaxLongValueFromTable(SCHEMA_TABLE_NAME, "internal_schema_id");
            LogWriter.qwrite("DEBUG", "internalSchemaID = " + ++internalSchemaID);
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't update schema definition: " + e.getMessage(), e);
        }
        XMLSchemaParseAndRegister parser = new XMLSchemaParseAndRegister();
        try {
            parser.parseXMLSchemaDOMElement(schema, internalSchemaID, prefixMap, this, false);
        }
        catch (XMLSchemaParserException e) {
            throw new StorageException(e.getMessage());
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            XMLFormatConverter.print(schema, buf);
        }
        catch (TransformerException e) {
            throw new StorageException("Can't create schema string", e);
        }
        try {
            PreparedStatement deleteStatement = this.db.prepareStatement("UPDATE " + SCHEMA_TABLE_NAME + " SET deleted=TRUE" + " WHERE " + ColName_SchemaTabSchemaID + "=?");
            PreparedStatement insertStatement = this.db.prepareStatement("INSERT INTO " + SCHEMA_TABLE_NAME + " (" + ColName_SchemaTabTargetNamespace + "," + ColName_SchemaTabSchemaID + "," + "internal_schema_id" + "," + ColName_SchemaTabSchemaDef + ")" + " VALUES (?, ?, " + internalSchemaID + ", ?)");
            try {
                deleteStatement.setString(1, parser.getSchemaID());
                this.db.executeUpdate(deleteStatement);
                insertStatement.setString(1, parser.getTargetNamespace());
                insertStatement.setString(2, parser.getSchemaID());
                insertStatement.setString(3, buf.toString());
                this.db.executeUpdate(insertStatement);
                this.db.commit();
            }
            catch (SQLException e) {
                throw new StorageException("Can't update schema definition: " + e.getMessage(), e);
            }
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't update schema definition: " + e.getMessage(), e);
        }
    }

    @Override
    public XMLSchemaSet getSchemasByNS(String namespaceURI, XMLSchemaSet schemaSet) throws StorageException {
        if (schemaSet == null) {
            schemaSet = new XMLSchemaSet();
        }
        String query = "SELECT " + ColName_SchemaTabSchemaDef + " FROM " + SCHEMA_TABLE_NAME + " WHERE " + ColName_SchemaTabTargetNamespace + "='" + namespaceURI + "'" + " AND deleted=FALSE";
        LogWriter.qwrite("DEBUG", "#" + query);
        try {
            DatabaseConnection.QueryResult r = this.db.executeQuery(query);
            while (r.next()) {
                String schemaStr = r.getString(1);
                XMLSchemaSet.Entry entry = schemaSet.add(schemaStr);
                if (entry == null) continue;
                for (String importNsURI : entry.getImportList()) {
                    this.getSchemasByNS(importNsURI, schemaSet);
                }
            }
            r.close();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        return schemaSet;
    }

    @Override
    public XMLSchemaSet getSchemasByNS(String namespaceURI) throws StorageException {
        return this.getSchemasByNS(namespaceURI, null);
    }

    @Override
    public XMLSchemaSet getSchemasOfElement(ElementName elementName) throws StorageException {
        return this.getSchemasByNS(elementName.getNamespace());
    }

    @Override
    public XMLSchemaSet getSchemasOfElement(ElementName elementName, XMLSchemaSet schemaSet) throws StorageException {
        return this.getSchemasByNS(elementName.getNamespace(), schemaSet);
    }

    protected String getSchema(String schemaID) throws StorageException {
        String query = "SELECT schema_definition FROM __schema__ WHERE schema_id='" + schemaID + "' AND deleted=FALSE";
        LogWriter.qwrite("DEBUG", "#", query);
        String ret = null;
        try {
            DatabaseConnection.QueryResult r = this.db.executeQuery(query);
            while (r.next()) {
                if (ret != null) {
                    throw new StorageException("schema bounded to schema id [" + schemaID + "] multiply defined");
                }
                ret = r.getString(1);
            }
            r.close();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        if (ret == null) {
            throw new StorageException("schema bounded to schema id [" + schemaID + "] not found");
        }
        return ret;
    }

    @Override
    public synchronized void registerTypeDefinition(TypeName typeName, TypeDefinition definition, String schemaID, long internalSchemaID, boolean cacheUpdateOnly) throws StorageException {
        assert (typeName != null);
        assert (definition != null);
        assert (schemaID != null);
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": ", "registerTypeDefinition: ", "[", typeName.getNamespace(), " ", typeName.getLocalName(), "]");
        this.registerUniversalNameIfNotRegistrated(typeName);
        typeDictionaryCache.registerType(typeName, definition);
        SQLDataType singleSQLDataType = definition.getSingleSQLDataType();
        if (singleSQLDataType != null) {
            LogWriter.qwrite("DEBUG", "single sql type = [", singleSQLDataType.getSQLBaseDataTypeString(), "]");
        } else {
            List<TableColumnDefinition> columns;
            LogWriter.qwrite("DEBUG", "single sql type = null");
            try {
                columns = definition.getCompositeSQLDataType(this, null);
            }
            catch (TypeException e) {
                throw new StorageException(e.getMessage(), e);
            }
            if (columns == null) {
                throw new StorageException("Can't determine type definition");
            }
        }
        if (cacheUpdateOnly) {
            return;
        }
        try {
            PreparedStatement updateStatement = this.db.prepareStatement("UPDATE " + TYPE_TABLE_NAME + " SET deleted=TRUE" + " WHERE " + "type_namespace" + "=?" + " AND " + "type_name" + "=?");
            PreparedStatement insertStatement = this.db.prepareStatement("INSERT INTO " + TYPE_TABLE_NAME + " (" + "type_namespace" + "," + "type_name" + "," + ColName_TypeTabSchemaURI + "," + "internal_schema_id" + ")" + " VALUES (?,?,?," + internalSchemaID + ")");
            try {
                updateStatement.setString(1, typeName.getNamespace());
                updateStatement.setString(2, typeName.getLocalName());
                insertStatement.setString(1, typeName.getNamespace());
                insertStatement.setString(2, typeName.getLocalName());
                insertStatement.setString(3, schemaID);
                this.db.executeUpdate(updateStatement);
                this.db.executeUpdate(insertStatement);
                this.db.commit();
            }
            catch (SQLException e) {
                throw new StorageException("Can't update schema definition: " + e.getMessage(), e);
            }
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't update type definition: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized TypeDefinition getTypeDefinition(TypeName typeName) throws StorageException {
        TypeDefinition t = typeDictionaryCache.getType(typeName);
        if (t != null) {
            return t;
        }
        String storageExceptionMessage = "Can't get type definition of " + typeName.toString();
        DatabaseConnection.QueryResult r = null;
        try {
            PreparedStatement queryStatement = this.db.prepareStatement("SELECT schema_uri FROM " + TYPE_TABLE_NAME + " WHERE " + "type_namespace" + "=?" + " AND " + "type_name" + "=?" + " AND " + "deleted" + "=FALSE");
            try {
                queryStatement.setString(1, typeName.getNamespace());
                queryStatement.setString(2, typeName.getLocalName());
                r = new DatabaseConnection.QueryResult(queryStatement.executeQuery(), queryStatement);
            }
            catch (SQLException e) {
                throw new StorageException("Can't get schema uri: " + e.getMessage(), e);
            }
            int count = 0;
            String schemaID = null;
            while (r.next()) {
                ++count;
                schemaID = r.getString(1);
            }
            if (count == 0 || schemaID == null) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            if (count >= 2) {
                throw new StorageException(storageExceptionMessage + ": " + "element type definition" + " multiply defined");
            }
            String schemaString = this.getSchema(schemaID);
            XMLSchemaParseAndRegister parser = new XMLSchemaParseAndRegister();
            try {
                parser.parseXMLSchemaString(schemaString, -1L, this, true);
            }
            catch (XMLSchemaParserException e) {
                throw new StorageException(e.getMessage());
            }
            TypeDefinition typeDefinition = typeDictionaryCache.getType(typeName);
            return typeDefinition;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(storageExceptionMessage + ": " + e.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (DatabaseConnectionException e) {
                throw new StorageException(storageExceptionMessage + ": " + e.getMessage());
            }
        }
    }

    private long getInternalSchemaIDFromExistType(TypeName typeName) throws StorageException {
        Object r = null;
        try {
            PreparedStatement queryStatement = this.db.prepareStatement("SELECT " + "internal_schema_id" + " FROM " + TYPE_TABLE_NAME + " WHERE " + "type_namespace" + "=?" + " AND " + "type_name" + "=?" + " AND " + "deleted" + "=FALSE");
            queryStatement.setString(1, typeName.getNamespace());
            queryStatement.setString(2, typeName.getLocalName());
            return this.db.getSingleLongValueFromPreparedStatement(queryStatement, 1);
        }
        catch (SQLException e) {
            return 0L;
        }
        catch (DatabaseConnectionException e) {
            return 0L;
        }
    }

    @Override
    public void registerElementDefinition(ElementName elementName, TypeName typeName, long elementInternalSchemaID, boolean cacheUpdateOnly) throws StorageException {
        LogWriter.qwrite("DEBUG", "registerElementDefinition: ", "[", elementName.getNamespace(), " - ", elementName.getLocalName(), "]: ", "[", typeName.getNamespace(), " - ", typeName.getLocalName(), "]");
        this.registerUniversalNameIfNotRegistrated(typeName);
        String elementID = this.getUniversalNameID(elementName);
        if (elementID == null) {
            this.registerUniversalNameIfNotRegistrated(elementName);
            elementID = this.getUniversalNameID(elementName);
        }
        LogWriter.qwrite("DEBUG", "elementID = [", elementID, "]");
        TypeDefinition type = this.getTypeDefinition(typeName);
        if (type == null) {
            throw new StorageException("unknown type " + typeName);
        }
        if (cacheUpdateOnly) {
            this.elementDictionaryCache.put(elementName, typeName);
            return;
        }
        try {
            String managementColumnsString;
            String tableColumnsString;
            long typeInternalSchemaID = this.getInternalSchemaIDFromExistType(typeName);
            PreparedStatement updateStatement = this.db.prepareStatement("UPDATE " + ELEMENT_TABLE_NAME + " SET deleted=TRUE" + " WHERE " + ColName_ElementTabElementNS + "=?" + " AND " + ColName_ElementTabElementName + "=?");
            PreparedStatement insertStatement = this.db.prepareStatement("INSERT INTO " + ELEMENT_TABLE_NAME + " (" + ColName_ElementTabElementNS + "," + ColName_ElementTabElementName + "," + ColName_ElementTabElementInternalSchemaID + "," + "type_namespace" + "," + "type_name" + "," + ColName_ElementTabTypeInternalSchemaID + ")" + " VALUES (?,?," + elementInternalSchemaID + ",?,?," + typeInternalSchemaID + ")");
            try {
                updateStatement.setString(1, elementName.getNamespace());
                updateStatement.setString(2, elementName.getLocalName());
                insertStatement.setString(1, elementName.getNamespace());
                insertStatement.setString(2, elementName.getLocalName());
                insertStatement.setString(3, typeName.getNamespace());
                insertStatement.setString(4, typeName.getLocalName());
                this.db.executeUpdate(updateStatement);
                this.db.executeUpdate(insertStatement);
                this.db.commit();
            }
            catch (SQLException e) {
                throw new StorageException("Can't update element definition: " + e.getMessage(), e);
            }
            String tableName = elementID;
            SQLDataType t = type.getSingleSQLDataType();
            TableDefinition tableDefinition = null;
            if (t != null) {
                tableColumnsString = ColumnNameFactory.getTopLevelElementColumnName() + " " + t.getSQLBaseDataTypeString();
            } else {
                try {
                    tableDefinition = new TableDefinition(type.getCompositeSQLDataType(this, null));
                    tableColumnsString = tableDefinition.getTableDefinitionString();
                }
                catch (TypeException e) {
                    throw new StorageException("Can't update element definition: " + e.getMessage(), e);
                }
            }
            String indexInstruction = null;
            if (ImplementationSwitches.instance().isMySQLBackend()) {
                managementColumnsString = ColName_SystemID + " integer not null auto_increment," + "index(" + ColName_SystemID + ")," + ColName_SystemTransactionID + " integer not null," + "index(" + ColName_SystemTransactionID + ")," + ColName_SystemCreateTime + " timestamp," + ColName_SystemUpdateTime + " timestamp," + ColName_SystemDeleted + " boolean not null default FALSE," + "index(" + ColName_SystemDeleted + "),";
            } else {
                managementColumnsString = ColName_SystemID + " integer not null," + ColName_SystemTransactionID + " integer not null," + ColName_SystemCreateTime + " timestamp," + ColName_SystemUpdateTime + " timestamp," + ColName_SystemDeleted + " boolean not null default FALSE,";
                indexInstruction = "CREATE INDEX __" + tableName + "__index__" + " ON " + tableName + "( " + ColName_SystemID + ", " + ColName_SystemTransactionID + ", " + ColName_SystemDeleted + " )";
            }
            String sqlInstruction = "CREATE TABLE " + tableName + " (" + managementColumnsString + tableColumnsString + ")";
            String engine = this.get_engine_string();
            String encoding = this.get_encoding_string();
            if (engine != null) {
                sqlInstruction = sqlInstruction + " " + engine;
            }
            if (encoding != null) {
                sqlInstruction = sqlInstruction + " " + encoding;
            }
            LogWriter.qwrite("DEBUG", "#", sqlInstruction);
            this.db.dropTableIfExists(tableName);
            this.db.executeUpdate(sqlInstruction);
            if (indexInstruction != null) {
                this.db.executeUpdate(indexInstruction);
            }
            if (tableDefinition != null) {
                for (String subTableName : tableDefinition.getSubTables(tableName)) {
                    String subTableSqlInstruction;
                    LogWriter.qwrite("DEBUG", "sub table = ", subTableName);
                    this.db.dropTableIfExists(subTableName);
                    String subTableIndexInstruction = null;
                    if (ImplementationSwitches.instance().isMySQLBackend()) {
                        subTableSqlInstruction = "CREATE TABLE " + subTableName + " (" + ColName_SystemID + " integer not null," + "index(" + ColName_SystemID + ")," + ColName_SystemParentID + " integer not null," + "index(" + ColName_SystemParentID + ")," + ColumnNameFactory.getTopLevelElementColumnName() + " " + SQLDataTypeConstant.BLOB.getSQLBaseDataTypeString() + ")";
                    } else {
                        subTableSqlInstruction = "CREATE TABLE " + subTableName + " (" + ColName_SystemID + " integer not null," + ColName_SystemParentID + " integer not null," + ColumnNameFactory.getTopLevelElementColumnName() + " " + SQLDataTypeConstant.BLOB.getSQLBaseDataTypeString() + ")";
                        subTableIndexInstruction = "CREATE INDEX __" + subTableName + "__index__" + " ON " + subTableName + "( " + ColName_SystemID + ", " + ColName_SystemParentID + " )";
                    }
                    if (engine != null) {
                        subTableSqlInstruction = subTableSqlInstruction + " " + engine;
                    }
                    if (encoding != null) {
                        subTableSqlInstruction = subTableSqlInstruction + " " + encoding;
                    }
                    LogWriter.qwrite("DEBUG", "#", subTableSqlInstruction);
                    this.db.executeUpdate(subTableSqlInstruction);
                    if (subTableIndexInstruction == null) continue;
                    this.db.executeUpdate(subTableIndexInstruction);
                }
            }
            this.db.commit();
            this.elementDictionaryCache.put(elementName, typeName);
        }
        catch (DatabaseConnectionException e) {
            e.printStackTrace();
            throw new StorageException("Can't update element definition: " + e.getMessage(), e);
        }
    }

    @Override
    public TypeName getElementTypeName(ElementName elementName) throws StorageException {
        TypeName ret = this.elementDictionaryCache.get(elementName);
        if (ret != null) {
            return ret;
        }
        String storageExceptionMessage = "Can't get type definition of element " + elementName.toString();
        PreparedStatement queryStatement = null;
        DatabaseConnection.QueryResult r = null;
        try {
            queryStatement = this.db.prepareStatement("SELECT " + "type_namespace" + "," + "type_name" + " FROM " + ELEMENT_TABLE_NAME + " WHERE " + ColName_ElementTabElementNS + "=?" + " AND " + ColName_ElementTabElementName + "=?" + " AND deleted=FALSE");
            try {
                queryStatement.setString(1, elementName.getNamespace());
                queryStatement.setString(2, elementName.getLocalName());
                r = new DatabaseConnection.QueryResult(queryStatement.executeQuery(), queryStatement);
            }
            catch (SQLException e) {
                throw new StorageException("Can't get element type name: " + e.getMessage(), e);
            }
            int count = 0;
            String typeNamespace = null;
            String typeLocalName = null;
            while (r.next()) {
                ++count;
                typeNamespace = r.getString(1);
                typeLocalName = r.getString(2);
            }
            if (count == 0 || typeNamespace == null || typeLocalName == null) {
                TypeName typeName = null;
                return typeName;
            }
            if (count >= 2) {
                throw new StorageException(storageExceptionMessage + ": " + "element type definition" + " multiply defined");
            }
            TypeName typeName = new TypeName(typeNamespace, typeLocalName);
            this.elementDictionaryCache.put(elementName, typeName);
            TypeName typeName2 = typeName;
            return typeName2;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(storageExceptionMessage + ": " + e.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (DatabaseConnectionException e) {
                throw new StorageException(storageExceptionMessage + ": " + e.getMessage());
            }
        }
    }

    @Override
    public void bulkInsertElement(BulkInsertBuffer buf, long transactionSN) throws StorageException {
        for (Map.Entry<ElementName, List<TypedInstance>> p : buf.getBuffer().entrySet()) {
            ElementName elementName = p.getKey();
            List<TypedInstance> objs = p.getValue();
            assert (!objs.isEmpty());
            String tableName = this.getUniversalNameID(elementName);
            try {
                ElementInserter.executeBulkInsert(this.db, tableName, objs, transactionSN);
            }
            catch (DatabaseConnectionException e) {
                throw new StorageException(e.getMessage(), e);
            }
        }
        buf.clear();
    }

    @Override
    public int insertElement(ElementName elementName, TypedInstance obj, long transactionSN) throws StorageException {
        String tableName = this.getUniversalNameID(elementName);
        List<TableColumn> columns = obj.getColumns();
        try {
            ElementInserter.executeInsert(this.db, tableName, columns, transactionSN);
            return 1;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("data insertion failed: " + e.getMessage(), e);
        }
    }

    @Override
    public int deleteElement(ElementName elementName, PredicateDescription predicate, long transactionSN, boolean virtualDelete) throws StorageException {
        String id = this.getUniversalNameID(elementName);
        if (id == null) {
            throw new StorageException(elementName + " not found");
        }
        String sqlString = virtualDelete ? "UPDATE " + id + " SET " + ColName_SystemDeleted + "=TRUE" : "DELETE FROM " + id;
        if (predicate != null) {
            sqlString = sqlString + " WHERE " + predicate.getSQLExpression();
        }
        LogWriter.qwrite("DEBUG", "#", sqlString);
        try {
            int ret = this.db.executeUpdate(sqlString);
            this.db.commit();
            return ret;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't delete element " + elementName.toString() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public int restoreElement(ElementName elementName, PredicateDescription predicate, long transactionSN) throws StorageException {
        String id = this.getUniversalNameID(elementName);
        if (id == null) {
            throw new StorageException(elementName + " not found");
        }
        String sqlString = "UPDATE " + id + " SET " + ColName_SystemDeleted + "=FALSE";
        if (predicate != null) {
            sqlString = sqlString + " WHERE " + predicate.getSQLExpression();
        }
        LogWriter.qwrite("DEBUG", "#", sqlString);
        try {
            int ret = this.db.executeUpdate(sqlString);
            this.db.commit();
            return ret;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't restore element " + elementName.toString() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public int updateElement(ElementName elementName, List<Pair<SimpleXPath, String>> updateValues, PredicateDescription predicate, long transactionSN, boolean virtualUpdate) throws StorageException {
        String id = this.getUniversalNameID(elementName);
        if (id == null) {
            throw new StorageException(elementName + " not found");
        }
        if (updateValues.isEmpty()) {
            return 0;
        }
        StringBuilder sqlString = new StringBuilder();
        sqlString.append("UPDATE " + id + " SET ");
        boolean firstColumn = true;
        for (Pair<SimpleXPath, String> p : updateValues) {
            String columnName;
            try {
                columnName = super.getShortXPathStringForDB(p.getFirst());
            }
            catch (StorageException e) {
                throw new StorageException("invalid property: " + p.getFirst(), e);
            }
            if (!firstColumn) {
                sqlString.append(",");
            }
            firstColumn = false;
            sqlString.append(columnName);
            sqlString.append("='");
            sqlString.append(p.getSecond());
            sqlString.append("'");
        }
        if (predicate != null) {
            sqlString.append(" WHERE " + predicate.getSQLExpression());
        }
        LogWriter.qwrite("DEBUG", "#", sqlString);
        try {
            int ret = this.db.executeUpdate(sqlString.toString());
            this.db.commit();
            return ret;
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't update element " + elementName.toString() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public TypedInstanceSet getTypedInstanceSet(ElementName elementName, String sqlWhereBlock, String sqlSortBlock, TransformationContext trans, long offsetCount, long limitCount) throws StorageException {
        TypeDefinition type = super.getElementTypeDefinition(elementName);
        if (type == null) {
            throw new StorageException("type of element " + elementName + " not found");
        }
        String tableName = this.getUniversalNameID(elementName);
        try {
            String retrieveColumnString;
            SQLDataType t = type.getSingleSQLDataType();
            if (t != null) {
                String tableColumnsString = ColumnNameFactory.getTopLevelElementColumnName();
                retrieveColumnString = t.getSQLRetrieveColumnString(tableColumnsString);
            } else {
                retrieveColumnString = new TableDefinition(type.getCompositeSQLDataType(this, null)).getCommaSeparatedColumnNamesForRawSQLString();
            }
            String sqlString = "SELECT _id_," + retrieveColumnString + " FROM " + tableName + " " + DEFAULT_SET_NAME + this.genWhereAndLimitBlocks(sqlWhereBlock, offsetCount, limitCount, sqlSortBlock);
            LogWriter.qwrite("DEBUG", "#", sqlString);
            return new TypedInstanceSet(type, this.db.executeQuery(sqlString), this);
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("data retrieve failed: " + e.getMessage(), e);
        }
        catch (TypeException e) {
            throw new StorageException("data retrieve failed: " + e.getMessage(), e);
        }
    }

    protected String genWhereAndLimitBlocks(String whereBlock, long offsetCount, long limitCount, String additionalBlock) {
        String sqlString = null;
        sqlString = whereBlock != null ? " WHERE _deleted_=FALSE AND (" + whereBlock + ")" : " WHERE _deleted_=FALSE";
        if (additionalBlock != null) {
            sqlString = sqlString + " " + additionalBlock;
        }
        if (limitCount >= 0L || offsetCount > 0L) {
            sqlString = sqlString + " LIMIT ";
            sqlString = limitCount < 0L ? sqlString + "0" : sqlString + Long.toString(limitCount);
            if (offsetCount > 0L) {
                sqlString = sqlString + " OFFSET " + Long.toString(offsetCount);
            }
        }
        return sqlString;
    }

    @Override
    public long getCountOfTypedInstanceSet(ElementName elementName, String sqlWhereBlock, long limitCount) throws StorageException {
        String tableName = null;
        try {
            tableName = this.getUniversalNameID(elementName);
            String sqlString = "SELECT count(*) FROM " + tableName + " " + DEFAULT_SET_NAME + this.genWhereAndLimitBlocks(sqlWhereBlock, 0L, limitCount, null);
            DatabaseConnection.QueryResult result = this.db.executeQuery(sqlString);
            long count = 0L;
            if (!result.next()) {
                throw new StorageException("something wrong for query:" + sqlString);
            }
            count = result.getLong(1);
            return count;
        }
        catch (DatabaseConnectionException ex) {
            throw new StorageException("Can't access table for " + tableName + ":" + ex.getMessage(), ex);
        }
    }

    @Override
    public DrmEnvelope getEnvelopeOfTypedInstanceSet(ElementName elementName, String propertyColName, String sqlWhereBlock, long limitCount) throws StorageException {
        String tableName = null;
        try {
            tableName = this.getUniversalNameID(elementName);
            this.db.executeUpdate("SET @geo = null");
            String realColName = GeometryPropertyTypeDefinition.convertShortXPathToColumnName(propertyColName);
            String sqlString = "SELECT AsText(@geo) FROM __element__ _s  WHERE (SELECT count(@geo := if(ifnull(@geo,1)=1," + realColName + "," + "Envelope(GeomFromText(concat('GeometryCollection('," + "AsText(" + realColName + ")," + "',',AsText(@geo),')')))))" + " FROM " + tableName + this.genWhereAndLimitBlocks(sqlWhereBlock, 0L, limitCount, null) + ")" + " LIMIT 1";
            DatabaseConnection.QueryResult result = this.db.executeQuery(sqlString);
            if (result.next()) {
                String bbox = result.getString(1);
                try {
                    DrmEnvelope env = DrmEnvelope.scanPolygonWKT(bbox);
                    return env;
                }
                catch (Exception ex) {
                    throw new StorageException(ex);
                }
            }
            return null;
        }
        catch (DatabaseConnectionException ex) {
            throw new StorageException("Can't access table for " + tableName + ":" + ex.getMessage(), ex);
        }
    }

    @Override
    public List<String> getSubTableValues(String tableName, long parentID) throws StorageException {
        String query = "SELECT " + ColumnNameFactory.getTopLevelElementColumnName() + " FROM " + tableName + " WHERE _parent_id_=" + parentID;
        LogWriter.qwrite("DEBUG", "#", query);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            DatabaseConnection.QueryResult r = this.db.executeQuery(query);
            while (r.next()) {
                String rawBytes = r.getString(1);
                if (rawBytes == null) continue;
                ret.add(r.getString(1));
            }
            r.close();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        return ret;
    }

    @Override
    public List<ElementName> getElementList() throws StorageException {
        DatabaseConnection.QueryResult queryResult;
        try {
            queryResult = this.db.executeQuery("SELECT " + ColName_ElementTabElementNS + "," + ColName_ElementTabElementName + " FROM " + ELEMENT_TABLE_NAME + " WHERE deleted=FALSE");
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        ArrayList<ElementName> featureTypeList = new ArrayList<ElementName>();
        try {
            DatabaseConnection.QueryResult r = queryResult;
            while (r.next()) {
                featureTypeList.add(new ElementName(r.getString(1), r.getString(2)));
            }
            r.close();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        return featureTypeList;
    }

    @Override
    public void registerUniversalNameIfNotRegistrated(UniversalName universalName) throws StorageException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": ", "registerUniversalNameIfNotRegistrated: ", universalName.getNamespace(), " - ", universalName.getLocalName(), "]");
        if (this.getUniversalNameID(universalName) != null) {
            LogWriter.qwrite("DEBUG", this.getClass().getName(), ": ", "registerUniversalNameIfNotRegistrated: ", "already registered ", universalName.getNamespace(), " - ", universalName.getLocalName(), "]");
            return;
        }
        try {
            String idString;
            this.db.startTransaction();
            long idNumber = this.db.getMaxLongValueFromTable(UNIVERSAL_NAME_ALIAS_TABLE_NAME, ColName_UNameTabSerialNum);
            String alias = idString = this.genUniversalIdString(universalName, ++idNumber);
            if (universalName.getNamespace() != null) {
                alias = alias + "-" + StringSplitter.getLastNonEmptyElement(universalName.getNamespace(), "/");
            }
            alias = alias + "-" + universalName.getLocalName();
            PreparedStatement s = this.db.prepareStatement("INSERT INTO " + UNIVERSAL_NAME_ALIAS_TABLE_NAME + " (" + ColName_UNameTabNameSpace + "," + ColName_UNameTabLocalName + "," + ColName_UNameTabSerialNum + "," + "id" + "," + ColName_UNameTabAlias + ")" + " VALUES (?,?,?,?,?)");
            try {
                s.setString(1, universalName.getNamespaceNonNull());
                s.setString(2, universalName.getLocalName());
                s.setLong(3, idNumber);
                s.setString(4, idString);
                s.setString(5, alias);
                this.db.executeUpdate(s);
                this.db.commit();
            }
            catch (SQLException e) {
                throw new StorageException("Can't update universal name id: " + e.getMessage(), e);
            }
            this.getUniversalNameID(universalName);
        }
        catch (DatabaseConnectionException e) {
            e.printStackTrace();
            try {
                this.db.rollback();
            }
            catch (DatabaseConnectionException de) {
                de.printStackTrace();
                throw new StorageException("Can't rollback database connection", de);
            }
            throw new StorageException("Can't update universal name id: " + e.getMessage(), e);
        }
    }

    @Override
    public String getUniversalNameID(UniversalName universalName) throws StorageException {
        String id = this.universalNameDictionaryCache.get(universalName);
        if (id != null) {
            return id;
        }
        DatabaseConnection.QueryResult queryResult = null;
        try {
            DatabaseConnection.QueryResult r = queryResult = this.db.executeQuery("SELECT id FROM " + UNIVERSAL_NAME_ALIAS_TABLE_NAME + " WHERE NOT deleted" + " AND " + ColName_UNameTabNameSpace + "=" + "'" + universalName.getNamespaceNonNull() + "'" + " AND " + ColName_UNameTabLocalName + "=" + "'" + universalName.getLocalName() + "'");
            long count = 0L;
            while (r.next()) {
                id = r.getString(1);
                ++count;
            }
            if (count == 0L) {
                String string = null;
                return string;
            }
            if (count >= 2L) {
                throw new StorageException("Database consistency error: id of [" + universalName.getNamespace() + " - " + universalName.getLocalName() + "] multiply defined");
            }
            this.universalNameDictionaryCache.put(universalName, id);
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
        finally {
            if (queryResult != null) {
                try {
                    queryResult.close();
                }
                catch (DatabaseConnectionException e) {
                    throw new StorageException("Can't close database connection", e);
                }
            }
        }
        return id;
    }

    @Override
    public Date getCurrentTime() throws StorageException {
        try {
            return this.db.getCurrentTime();
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException(e);
        }
    }

    protected String genUniversalIdString(UniversalName uname, Long serialNum) {
        String idString = "id" + Long.toString(serialNum);
        return idString;
    }

    @Override
    public long registerTransactionURI(String uri) throws StorageException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ".registerTransactionURI(): ", "uri=", uri);
        long serialNumber = 0L;
        try {
            PreparedStatement statement = this.db.prepareStatement("INSERT INTO " + TRANSACTION_LOG_TABLE_NAME + " (" + "id" + ", " + ColName_TransTabURI + ")" + " VALUES (?, ?)");
            try {
                serialNumber = this.db.getMaxLongValueFromTable(TRANSACTION_LOG_TABLE_NAME, "id");
                this.db.startTransaction();
                statement.setLong(1, ++serialNumber);
                statement.setString(2, uri);
                this.db.executeUpdate(statement);
                this.db.commit();
            }
            catch (SQLException ex) {
                LogWriter.qwrite("DEBUG", this.getClass().getName(), ".registerTransactionURI(): ", "SQLException: " + ex.getMessage());
                this.db.rollback();
                throw new StorageException("Can't insert transaction log:" + ex.getMessage(), ex);
            }
            catch (DatabaseConnectionException ex) {
                LogWriter.qwrite("DEBUG", this.getClass().getName(), ".registerTransactionURI(): ", "DatabaseConnectionException: " + ex.getMessage());
                this.db.rollback();
                throw new StorageException("Can't insert transaction log:" + ex.getMessage(), ex);
            }
        }
        catch (DatabaseConnectionException ex) {
            LogWriter.qwrite("DEBUG", this.getClass().getName(), ".registerTransactionURI(): ", "DatabaseConnectionException: " + ex.getMessage());
            throw new StorageException("Can't update transaction log:" + ex.getMessage(), ex);
        }
        return serialNumber;
    }

    @Override
    public long getTransactionSerialNumber(String uri) throws StorageException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), "::getTransactionSerialNumber(): ", "uri=", uri);
        long serialNumber = 0L;
        try {
            DatabaseConnection.QueryResult result = this.db.executeQuery("SELECT id from __transaction_log__ where uri='" + uri + "'");
            serialNumber = result.next() ? result.getLong(1) : 0L;
            if (result.next()) {
                throw new StorageException("multiple serial number for Transaction URI:" + uri);
            }
        }
        catch (DatabaseConnectionException ex) {
            throw new StorageException("Can't access transaction log:" + ex.getMessage(), ex);
        }
        return serialNumber;
    }

    @Override
    public String getMostRecentTransactionURI() throws StorageException {
        LogWriter.qwrite("DEBUG", this.getClass().getName(), "::getMostRecentTransactionURI()");
        String uri = null;
        try {
            DatabaseConnection.QueryResult result = this.db.executeQuery("SELECT uri from __transaction_log__ order by id desc limit 1");
            uri = result.next() ? result.getString(1) : null;
            if (result.next()) {
                throw new StorageException("multiple uri for most recent transaction");
            }
        }
        catch (DatabaseConnectionException ex) {
            throw new StorageException("Can't access transaction log:" + ex.getMessage(), ex);
        }
        return uri;
    }

    @Override
    public String getMostRecentTransactionURIFor(String nsURI, String localname) throws StorageException {
        return this.getMostRecentTransactionURIFor(new UniversalName(nsURI, localname));
    }

    @Override
    public String getMostRecentTransactionURIFor(UniversalName uname) throws StorageException {
        String featureTableName = this.getUniversalNameID(uname);
        String uri = null;
        try {
            DatabaseConnection.QueryResult result = this.db.executeQuery("SELECT uri from __transaction_log__ where id= (select max(_transaction_id_) from " + featureTableName + ")" + " limit 1");
            uri = result.next() ? result.getString(1) : null;
            if (result.next()) {
                throw new StorageException("multiple uri for most recent transaction");
            }
        }
        catch (DatabaseConnectionException ex) {
            throw new StorageException("Can't access transaction log:" + ex.getMessage(), ex);
        }
        return uri;
    }

    private synchronized void updateCoordTransDictionary() throws DatabaseConnectionException {
        coordTransDictionary = new CoordinateSystemTransformationDictionary();
        PreparedStatement get = this.db.prepareStatement("SELECT " + "id" + "," + ColName_CoordTransSource + "," + ColName_CoordTransTarget + "," + ColName_CoordTransSourceDim + "," + ColName_CoordTransTargetDim + "," + ColName_CoordTransTargetMethod + "," + ColName_CoordTransValue + " FROM " + COORD_TRANS_TABLE_NAME + " WHERE " + "deleted" + "=FALSE");
        try {
            DatabaseConnection.QueryResult r = this.db.executeQuery(get);
            while (r.next()) {
                double[][] matrix;
                String id = r.getString(1);
                String source = r.getString(2);
                String target = r.getString(3);
                long sourceDim = r.getLong(4);
                long targetDim = r.getLong(5);
                String method = r.getString(6);
                String value = r.getString(7);
                assert (method.equals("affine"));
                try {
                    LogWriter.qwrite("DEBUG", "TextUtil.parseMatrixValue:", "value = [", value, "],", "sourceDim = ", sourceDim, ",", "targetDim + 1 = ", targetDim + 1L);
                    matrix = TextUtil.parseMatrixValue(value, sourceDim, targetDim + 1L);
                }
                catch (ParseException e) {
                    throw new DatabaseConnectionException("matrix parsing failed: " + e.getMessage(), e);
                }
                coordTransDictionary.put(new AffineCoordinateSystemTransformation(id, new CoordinateSystem(source), new CoordinateSystem(target), sourceDim, targetDim, matrix));
            }
            r.close();
        }
        catch (DatabaseConnectionException e) {
            throw new DatabaseConnectionException("failed to create coordinate system transformation dictionary: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void registerCoordinateSystemTransformation(CoordinateSystemTransformation trans) throws StorageException {
        try {
            PreparedStatement del = this.db.prepareStatement("UPDATE " + COORD_TRANS_TABLE_NAME + " SET " + "deleted" + "=TRUE" + " WHERE " + "id" + "=?");
            del.setString(1, trans.getIdentifier());
            this.db.executeUpdate(del);
            PreparedStatement ins = this.db.prepareStatement("INSERT INTO " + COORD_TRANS_TABLE_NAME + " (" + "id" + "," + ColName_CoordTransSource + "," + ColName_CoordTransTarget + "," + ColName_CoordTransSourceDim + "," + ColName_CoordTransTargetDim + "," + ColName_CoordTransTargetMethod + "," + ColName_CoordTransValue + "," + "deleted" + ")" + " VALUES (?, ?, ?, ?, ?, ?, ?, FALSE)");
            ins.setString(1, trans.getIdentifier());
            ins.setString(2, trans.getSourceCS().getSrsName());
            ins.setString(3, trans.getTargetCS().getSrsName());
            ins.setLong(4, trans.getSourceDimension());
            ins.setLong(5, trans.getTargetDimension());
            ins.setString(6, trans.getTransformName());
            ins.setString(7, trans.encode());
            this.db.executeUpdate(ins);
            this.db.commit();
        }
        catch (SQLException e) {
            throw new StorageException("Can't update coordinate system transformation: " + e.getMessage(), e);
        }
        catch (DatabaseConnectionException e) {
            throw new StorageException("Can't update coordinate system transformation: " + e.getMessage(), e);
        }
        coordTransDictionary.put(trans);
    }

    @Override
    public synchronized CoordinateSystemTransformationDictionary getCoordTransDictionary() throws StorageException {
        return coordTransDictionary;
    }
}

