#include  "ip_address.h"
#include  "posix_compat_socket_headers.h"
#include  "compat_stringstream.h"
#include  <iostream>
#include  <cstring>
#include  <cstdio>

IPv4_Address::IPv4_Address( unsigned char  a ,  unsigned char  b ,
			    unsigned char  c ,  unsigned char  d )
	: address(   ( static_cast<ip_address_t>(a) << (8 * 3) )
		   + ( static_cast<ip_address_t>(b) << (8 * 2) )
		   + ( static_cast<ip_address_t>(c) << (8 * 1) )
		   + ( static_cast<ip_address_t>(d) << (8 * 0) ) )
{
	this -> address = htonl( this -> address );
}

IPv4_Address::IPv4_Address( const std::string &  host )
	: address( 0x00000000 )
{
	struct hostent *	hp;
	if ( (hp = gethostbyname( host.c_str() ))  ==  NULL )
	{
		std::perror( "gethostbyname" );
	}

	std::memcpy( &address , hp -> h_addr , hp -> h_length );
}

IPv4_Address::IPv4_Address( Byte_Order  order ,  ip_address_t  addr )
	: address( addr )
{
	if ( order == Network_Byte_Order )
	{
		this -> address = htonl( this -> address );
	}
}

ip_address_t  IPv4_Address::host_byte_order() const
{
	// <<TRANSLATE TO HOST BYTE ORDER>>
	// translate network byte order
	//   to host depend(NOT NETWORK) byte order.

	return( htonl( this -> address ) );
}

ip_address_t  IPv4_Address::network_byte_order() const
{
	return( this -> address );
}

IPv4_Address::operator std::string() const
{
	compat_ostringstream	str;

	ip_address_t	addr = this -> host_byte_order();

	str << ((addr >> (8*3)) & 0xff) << "."
	    << ((addr >> (8*2)) & 0xff) << "."
	    << ((addr >> (8*1)) & 0xff) << "."
	    << ((addr >> (8*0)) & 0xff);

	return( str.str() );
}

std::ostream &  operator<< ( std::ostream &  ostrm ,
			     const IPv4_Address &  addr )
{
	ostrm << static_cast<std::string>( addr );

	return( ostrm );
}
