/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import daruma.util.LogWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class PropertyReader {
    private static final String DEFAULT_PROPERTY_FILE = "daruma.properties";
    private static final String PROPERTY_NAME = "daruma.properties";
    private static String cPropertyFile;
    private static Properties prop;

    private static void initialize() throws FileNotFoundException {
        PropertyReader.initialize(System.getProperty("daruma.properties", "daruma.properties"));
    }

    public static void initialize(String path) throws FileNotFoundException {
        cPropertyFile = path;
        PropertyReader.initialize(new FileInputStream(cPropertyFile));
    }

    public static void initialize(InputStream in) {
        try {
            prop = new Properties();
            prop.load(in);
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR [PropertyReader] " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            System.err.println("ERROR [PropertyReader] " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR [PropertyReader] " + e.getMessage());
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
    }

    public static String getProperty(String propName) {
        return PropertyReader.getProperty(propName, null);
    }

    public static String getProperty(String propName, String def) {
        if (prop == null) {
            try {
                PropertyReader.initialize();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return prop.getProperty(propName, def);
    }

    public static boolean getProperty(String propName, boolean def) {
        String value = Boolean.toString(def);
        return PropertyReader.getPropertyBoolean(propName, value);
    }

    public static ArrayList getArrayProperty(String propName) {
        String array_kind;
        String result;
        int i = 0;
        ArrayList<String> array_value = new ArrayList<String>();
        while ((result = PropertyReader.getProperty(array_kind = propName + "." + i)) != null) {
            array_value.add(result);
            ++i;
        }
        return array_value;
    }

    public static int getPropertyInt(String propName) {
        return PropertyReader.getProperty(propName, 0);
    }

    public static int getProperty(String propName, int def) {
        String value = PropertyReader.getProperty(propName, Integer.toString(def));
        int result = 0;
        try {
            result = value == null ? def : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            System.err.println("ERROR [PropertyReader:getProperty]" + e.getMessage());
            throw new NumberFormatException(e.getMessage());
        }
        return result;
    }

    private static boolean getPropertyBoolean(String propName, String def) {
        String value = PropertyReader.getProperty(propName, def);
        boolean result = Boolean.valueOf(def);
        if (value != null) {
            if (!value.equals("true") && !value.equals("false")) {
                LogWriter.qwrite("ERROR", "invalid property value, ", "property name = [", propName, "], ", "value = [", value, "]");
                System.exit(1);
            }
            result = Boolean.valueOf(value);
        }
        return result;
    }

    public static String getFileName() {
        if (prop == null) {
            try {
                PropertyReader.initialize();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return cPropertyFile;
    }

    public static String getDefaultPropertyFile() {
        return "daruma.properties";
    }

    static {
        prop = null;
    }
}

