package daruma.sql;

import daruma.sql.DatabaseConnection;

public class MySQLDatabaseConnection extends DatabaseConnection
{
    private String mysqlHost;
    private int mysqlPort;

    public MySQLDatabaseConnection( String mysqlHost, int mysqlPort )
    {
        this.mysqlHost = mysqlHost;
        this.mysqlPort = mysqlPort;
    }

    @Override
    protected String getDatabaseURIPrefix()
    {
        return "jdbc:mysql://" + this.mysqlHost + ":" + this.mysqlPort + "/";
    }

    @Override
    protected String getDatabaseURIPostfix()
    {
        return "?useUnicode=true"
               + "&characterEncoding=UTF-8"
               + "&autoReconnect=true";
//             + "&useCursorFetch=true"
    }

    @Override
    protected void connectHook() throws DatabaseConnectionException
    {
//	this.executeUpdate( "SET time_zone='+00:00'" );
    }
}
