/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class EncodingConversionOutputStream
extends FilterOutputStream {
    private String cEncoding;

    public EncodingConversionOutputStream(OutputStream o, String enc) throws UnsupportedEncodingException {
        super(o);
        if (!this.is_supported_encoding(enc)) {
            throw new UnsupportedEncodingException("Specified encoding \"" + enc + "\" is not supported by the system.");
        }
        this.cEncoding = enc;
    }

    private byte[] conv(byte[] b) throws UnsupportedEncodingException {
        String s = new String(b);
        return s.getBytes(this.cEncoding);
    }

    private boolean is_supported_encoding(String enc) {
        try {
            "test".getBytes(enc);
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        return true;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(this.conv(b));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        buf.write(b, off, len);
        this.write(buf.toByteArray());
        buf.close();
    }
}

