package daruma.geometry;

import daruma.geometry.DrmPolygon;
import daruma.geometry.DrmLinearRing;
import daruma.geometry.DrmPoint;

public class DrmBox extends DrmPolygon /* XXX: should be DrmGeometry? */ 
{
    private int dimension;

    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    public DrmBox( DrmPoint minPoint, DrmPoint maxPoint )
						    throws GeometryException
    {
	super();

	if ( minPoint.getDimension() != maxPoint.getDimension() )
	{
		throw new GeometryException
		    ( "Point dimension mismatch in Box" );
	}

	this.dimension = minPoint.getDimension();

	this.minX = minPoint.getX();
	this.minY = minPoint.getY();
	this.maxX = maxPoint.getX();
	this.maxY = maxPoint.getY();


	DrmLinearRing outerBoundary = new DrmLinearRing();
	outerBoundary.add( new DrmPoint( minX , minY ) );
	outerBoundary.add( new DrmPoint( maxX , minY ) );
	outerBoundary.add( new DrmPoint( maxX , maxY ) );
	outerBoundary.add( new DrmPoint( minX , maxY ) );
	outerBoundary.add( new DrmPoint( minX , minY ) );

	super.setOuterBoundary( outerBoundary );
    }

    public int getDimension()
    {
	return this.dimension;
    }

    public double getMinX()
    {
	return this.minX;
    }

    public double getMinY()
    {
	return this.minY;
    }

    public double getMaxX()
    {
	return this.maxX;
    }

    public double getMaxY()
    {
	return this.maxY;
    }
}
