package daruma.storage_manager.type_definition;

import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.TypeName;

public class XMLSchemaElementDefinition
{
	public static final long	MAX_OCCURS_UNBOUNDED = -1;

	private	TypeDefinition	type;

	private	TypeName	typeName;
	private	ElementName	elementName;
	private	long		minOccurs;
	private	long		maxOccurs;
        /* !!! [[09/08/26 22:01 I.Noda]] !!! */
	private boolean		indexed ;

	public	XMLSchemaElementDefinition( TypeDefinition  type ,
					    ElementName  elementName ,
					    TypeName  typeName ,
					    long  minOccurs ,
					    long  maxOccurs ,
					    boolean indexed)
	{
		this.type        = type;
		this.elementName = elementName;
		this.typeName    = typeName;
		this.minOccurs   = minOccurs;
		this.maxOccurs   = maxOccurs;
		this.indexed	 = indexed ;
	}

	public	TypeDefinition	getType()
	{
		return( this.type );
	}

	public	ElementName	getElementName()
	{
		return( this.elementName );
	}

	public	TypeName	getTypeName()
	{
		return( this.typeName );
	}

	public	long	getMinOccurs()
	{
		return( this.minOccurs );
	}

	public	long	getMaxOccurs()
	{
		return( this.maxOccurs );
	}

	public	boolean	maxOccursIsGraterEquals( long  occurs )
	{
		return( this.maxOccurs == MAX_OCCURS_UNBOUNDED
		     || this.maxOccurs >= occurs );
	}

	/* <<< [[09/08/26 22:01 I.Noda]] <<< */
	// for misp:indexed attribute in xsd:element defs. 
	public	boolean	getIndexed()
	{
		return( this.indexed );
	}
	/* >>> [[09/08/26 22:01 I.Noda]] >>> */

}
