#ifndef	   STREAM_SOCKET_H_INCLUDED
#define	   STREAM_SOCKET_H_INCLUDED

#ifdef HAVE_CONFIG_H
  #include  "config.h"
#endif

#include  "ip_address.h"
#include  "posix_compat_socket_headers.h"
#include  <unistd.h>
#include  <iostream>
#include  <string>

class  Stream_Socket
{
protected:
	SOCKET_FD_TYTE	sfd;
	int		domain;
	int		type;
	std::string	socket_file;
	bool		ipv4_only;

	std::ostream *	error_stream;

	bool		connected_flag;

	bool		input_end_of_file;
	bool		output_end_of_file;

protected:
	void		system_error( const std::string &  message ,
				      int  err ) const;
	void		internal_error( const std::string &  message ) const;

public:
	enum Socket_No_Error { No_Error };
	class Socket_Opened_Socket {};
	static const Socket_Opened_Socket	Opened_Socket;

	 Stream_Socket();
	 Stream_Socket( Socket_Opened_Socket ,
			SOCKET_FD_TYTE  sock_fd ,
			int  sock_domain = AF_INET );
	 Stream_Socket( Socket_Opened_Socket ,
			SOCKET_FD_TYTE  sock_fd ,
			int  sock_domain ,
			Socket_No_Error );
	 Stream_Socket( Socket_No_Error );
	 Stream_Socket( std::ostream &  err );
	 Stream_Socket( int  sock_domain ,  int  sock_type ,  int  protocol ,
			Socket_No_Error );
	 Stream_Socket( int  sock_domain , int  sock_type = SOCK_STREAM ,
			int  protocol = 0 ,  std::ostream &  err = std::cerr );
	 Stream_Socket( const std::string &  host ,
			port_number_t  port ,
			bool  ipv4_only = false );
	~Stream_Socket();


	//
	//  socket
	//
	int	socket( int  sock_domain ,  int  sock_type ,
			int  protocol = 0 );

	int	socket( Socket_Opened_Socket ,
			SOCKET_FD_TYTE  sock_fd , int  sock_domain = AF_INET );

	int	socket( Socket_Opened_Socket ,
			SOCKET_FD_TYTE  sock_fd , int  sock_domain ,
			Socket_No_Error );

	//
	//  bind
	//
	int	bind( const struct sockaddr *  soc_addr ,
		      SOCKLEN_T  soc_addr_len );
	int	bind( const struct sockaddr_in *  soc_addr_in );
#ifdef HAVE_SOCKADDR_UN
	int	bind( const struct sockaddr_un *  soc_addr_un );
#endif
	int	bind( const std::string &  path );
	int	bind( port_number_t  port );


	//
	//  connect
	//
	int	connect( const struct sockaddr *  soc_addr ,
			 SOCKLEN_T  soc_addr_len );
	int	connect( const struct sockaddr *  soc_addr ,
			 SOCKLEN_T  soc_addr_len ,
			 const std::string &  address_representation );
	int	connect( const struct sockaddr_un *  soc_addr_un );
	int	connect( const struct sockaddr_in *  soc_addr_in );
	int	connect( const std::string &  path );
#if 0
	int	connect( ip_address_t  ip_addr ,  port_number_t  port );
#endif
	int	connect( const std::string &  host ,  port_number_t  port );
	int	connect( const IPv4_Address &  ip_addr ,
			 port_number_t  port );
	int	connect( port_number_t  port );


	//
	//  listen
	//
	int	listen( int  backlog = SOMAXCONN );


	//
	//  accept
	//
	int	accept( struct sockaddr *  soc_addr ,
			SOCKLEN_T *  soc_addr_len );
	int	accept( struct sockaddr_un *  soc_addr_un );
	int	accept( struct sockaddr_in *  soc_addr_in );


	//
	//  make server socket
	//
	int	make_server_socket
		( port_number_t  port ,
		  const char * hostname = static_cast<const char *>(0),
		  bool  ipv4_only = false );


	//
	//  make connection
	//
	int	make_connection( const std::string &  host ,
				 port_number_t  port ,
				 bool  ipv4_only = false );


	//
	//  read
	//
	ssize_t	read( void *  p ,  size_t  siz );
	ssize_t	read_all( std::string *  str );


	//
	//  write
	//
	ssize_t	write( const void *  p ,  size_t  siz );
	ssize_t	write( const std::string &  str );

	ssize_t	write_all( const void *  p ,  size_t  siz );
	ssize_t	write_all( const std::string &  str );


	//
	//  recv
	//
	ssize_t	recv( void *  p ,  size_t  siz ,  int  flags = 0 );


	//
	//  send
	//
	ssize_t	send( const void *  p ,  size_t  siz ,  int  flags = 0 );


	//
	//  shutdown
	//
	int	shutdown( int  how );


	//
	//  close
	//
	int	close();


	//
	// close on exec
	//
	int	set_close_on_exec();


	// poll
	int	poll( int  timeout /* msec */ = 0 ) const;


	//
	// file discriptor
	//
	int	fd() const;


	//
	// validity checks
	//
	bool	valid() const;
	operator bool() const;

	bool	input_eof() const;
	bool	output_eof() const;

	bool	connected() const;
};


#endif	/* STREAM_SOCKET_H_INCLUDED */
