/*
 * Decompiled with CFR 0.152.
 */
package mispClient.commands;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import daruma.xml.util.XMLParseErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import mispClient.MispCommand;
import mispClient.MispCommandException;
import xmlUtil.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCapabilitiesMispCommand
extends MispCommand {
    private static final String GET_CAPABILITIES_ELEMENT_NAME = "GetCapabilities";
    private static final String MISP_PREFIX = "misp";
    private List<ElementName> features = new ArrayList<ElementName>();

    @Override
    public InputStream getInputStream() {
        StringBuilder buf = new StringBuilder();
        buf.append("<misp:GetCapabilities xmlns:misp=\"" + URI.MISP + "\"/>");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    @Override
    public void processResponse(InputStream in) throws MispCommandException {
        List<UniversalName> names;
        try {
            names = XMLUtil.getUniversalNamesFromXPathQName("//*[local-name()='Name' and namespace-uri()='" + URI.MISP + "']", in);
        }
        catch (XMLParseErrorException e) {
            throw new MispCommandException(e);
        }
        catch (XPathExpressionException e) {
            throw new MispCommandException(e);
        }
        for (UniversalName n : names) {
            this.features.add(new ElementName(n));
        }
    }

    public List<ElementName> getFeatureList() {
        return this.features;
    }
}

