package daruma.geometry;

import daruma.geometry.DrmGeometry;
import daruma.geometry.DrmPoint;

import java.util.List;
import java.util.ArrayList;

import com.vividsolutions.jts.geom.* ;
import com.vividsolutions.jts.geom.impl.* ;
import daruma.geometry.OgcGeometryFactory ;

public class DrmLineString extends DrmGeometry
{
	private	List<DrmPoint>	points;

	public	DrmLineString()
	{
		this.points = new ArrayList<DrmPoint>();
	}

	public	void	add( DrmPoint  point )
	{
		this.points.add( point );
	}

	public	List<DrmPoint>	getPoints()
	{
		return( this.points );
	}

	public	DrmPoint	get( int  index )
	{
		return( this.points.get( index ) );
	}

	@Override
	public DrmLineString transform( CoordinateSystemTransformation trans )
	    throws TransformationException
	{
		DrmLineString ret = new DrmLineString();

		for ( DrmPoint p : points )
		{
			ret.add( trans.transform( p ) );
		}

		return ret;
	}

    //------------------------------------------------------------
    /**
     * geometry generator
     */
    @Override
    public LineString genGeometry(OgcGeometryFactory geoFactory) {
	CoordinateSequence coords = geoFactory.newCoords(points.size(), 2) ;

	int i = 0 ;
	for(DrmPoint point : points) {
	    if ( point.getDimension() == 3 ) {
		geoFactory.setCoordinate3D(coords,i,point.getX(), point.getY(),point.getZ()) ;
	    } else {
		geoFactory.setCoordinate2D(coords,i,point.getX(), point.getY()) ;
	    }

	    i++ ;
	}

	return geoFactory.createLineString(coords) ;
    }
}
