package daruma.auth;

import daruma.util.EqualChecker;

public class Account
{
    private String name;

    public Account( String name )
    {
	this.name = name;
    }

    public String getName()
    {
	return this.name;
    }

    @Override
    public boolean equals( Object obj )
    {
	if ( ! (obj instanceof Account) )
	{
	    return false;
	}

	Account acc = (Account)obj;

	return EqualChecker.equals( acc.getName(), this.getName() );
    }

    @Override
    public int hashCode()
    {
	if ( this.name == null )
	{
	    return 0;
	}

	return this.name.hashCode();
    }
}
