﻿using System;
using System.Collections.Generic;
using System.Text;

namespace DataUnit.Core
{
    public class Config
    {
        private string _outputPath;

        public string OutputPath
        {
            get { return _outputPath; }
            set { _outputPath = value.Trim(); }
        }
        private string _sqlPath;

        public string SqlPath
        {
            get { return _sqlPath; }
            set { _sqlPath = value.Trim(); }
        }
        private Mail _mailConfig = new Mail();

        public Mail MailConfig
        {
            get { return _mailConfig; }
            set { _mailConfig = value; }
        }

        private string[] _connectionString;

        public string[] ConnectionString
        {
            get { return _connectionString; }
            set { _connectionString = value; }
        }
        private DbKind _dbKind;

        public DbKind DbKind
        {
            get { return _dbKind; }
            set { _dbKind = value; }
        }

    }

    public enum DbKind
    {
        SqlServer = 1,
        Oracle = 2,
        Mdb = 3,
        Odbc = 4,
    }
}

