/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import java.io.Serializable;
import java.util.SimpleTimeZone;

public class TimeZone
implements Serializable {
    public int minutes;
    public static final TimeZone ZERO = new ZeroTimeZone();
    public static final java.util.TimeZone JAVA_TIME_ZONE_ZERO = new JavaZeroTimeZone();
    public static final java.util.TimeZone JAVA_TIME_ZONE_MISSING = new JavaMissingTimeZone();
    private static final long serialVersionUID = 1L;

    public int hashCode() {
        return this.minutes;
    }

    private TimeZone(int minutes) {
        if (minutes < -840 || minutes > 840) {
            throw new IllegalArgumentException();
        }
        this.minutes = minutes;
    }

    public static TimeZone create(int minutes) {
        return new TimeZone(minutes);
    }

    public boolean equals(Object o) {
        return ((TimeZone)o).minutes == this.minutes;
    }

    private static class JavaMissingTimeZone
    extends SimpleTimeZone
    implements Serializable {
        private static final long serialVersionUID = 1L;

        JavaMissingTimeZone() {
            super(0, "XSD missing timezone");
        }

        protected Object readResolve() {
            return JAVA_TIME_ZONE_MISSING;
        }
    }

    private static class JavaZeroTimeZone
    extends SimpleTimeZone
    implements Serializable {
        private static final long serialVersionUID = 1L;

        JavaZeroTimeZone() {
            super(0, "XSD 'Z' timezone");
        }

        protected Object readResolve() {
            return JAVA_TIME_ZONE_ZERO;
        }
    }

    private static class ZeroTimeZone
    extends TimeZone {
        private static final long serialVersionUID = 1L;

        ZeroTimeZone() {
            super(0);
        }

        protected Object readResolve() {
            return ZERO;
        }
    }
}

