/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.driver.textui;

import com.sun.msv.driver.textui.Debug;
import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.driver.textui.ReportErrorHandler;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.relax.RELAXModule;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.grammar.xmlschema.ElementDeclExp;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.relaxns.grammar.RELAXGrammar;
import com.sun.msv.relaxns.verifier.SchemaProviderImpl;
import com.sun.msv.util.Util;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.ValidationUnrecoverableException;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.identity.IDConstraintChecker;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.resolver.tools.CatalogResolver;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.dispatcher.SchemaProvider;
import org.iso_relax.dispatcher.impl.DispatcherImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Driver {
    static SAXParserFactory factory;
    public static final String MSG_DTDVALIDATION = "Driver.DTDValidation";
    public static final String MSG_PARSER = "Driver.Parser";
    public static final String MSG_USAGE = "Driver.Usage";
    public static final String MSG_UNRECOGNIZED_OPTION = "Driver.UnrecognizedOption";
    public static final String MSG_START_PARSING_GRAMMAR = "Driver.StartParsingGrammar";
    public static final String MSG_PARSING_TIME = "Driver.ParsingTime";
    public static final String MSG_VALIDATING = "Driver.Validating";
    public static final String MSG_VALIDATION_TIME = "Driver.ValidationTime";
    public static final String MSG_VALID = "Driver.Valid";
    public static final String MSG_INVALID = "Driver.Invalid";
    public static final String ERR_LOAD_GRAMMAR = "Driver.ErrLoadGrammar";
    public static final String MSG_BAILOUT = "Driver.BailOut";
    public static final String MSG_FAILED_TO_IGNORE_EXTERNAL_DTD = "Driver.FailedToIgnoreExternalDTD";
    public static final String MSG_WARNING_FOUND = "Driver.WarningFound";

    private static void printVersion() {
        System.out.println("Multi Schema Validator Ver." + ResourceBundle.getBundle("version").getString("version"));
    }

    private static void usage() {
        System.out.println(Driver.localize(MSG_USAGE));
    }

    public static void dumpRELAXModule(RELAXModule m) throws Exception {
        System.out.println("*** top level ***");
        System.out.println(ExpressionPrinter.printFragment(m.topLevel));
        System.out.println("\n $$$$$$[ " + m.targetNamespace + " ]$$$$$$");
        System.out.println("*** elementRule ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(m.elementRules));
        System.out.println("*** hedgeRule ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(m.hedgeRules));
        System.out.println("*** attPool ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(m.attPools));
        System.out.println("*** tag ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(m.tags));
    }

    public static void dumpTREX(TREXGrammar g) throws Exception {
        System.out.println("*** start ***");
        System.out.println(ExpressionPrinter.printFragment(g.exp));
        System.out.println("*** others ***");
        System.out.print(ExpressionPrinter.fragmentInstance.printRefContainer(g.namedPatterns));
    }

    public static void dumpXMLSchema(XMLSchemaGrammar g) throws Exception {
        System.out.println("*** top level ***");
        System.out.println(ExpressionPrinter.printFragment(g.topLevel));
        Iterator itr = g.iterateSchemas();
        while (itr.hasNext()) {
            XMLSchemaSchema s = (XMLSchemaSchema)itr.next();
            Driver.dumpXMLSchema(s);
        }
    }

    public static void dumpXMLSchema(XMLSchemaSchema s) throws Exception {
        System.out.println("\n $$$$$$[ " + s.targetNamespace + " ]$$$$$$");
        System.out.println("*** elementDecls ***");
        ReferenceExp[] es = s.elementDecls.getAll();
        int i = 0;
        while (i < es.length) {
            ElementDeclExp exp = (ElementDeclExp)es[i];
            System.out.println(exp.name + "  : " + ExpressionPrinter.printContentModel(exp.getContentModel().getExpandedExp(s.pool)));
            ++i;
        }
        System.out.println("*** complex types ***");
        System.out.print(ExpressionPrinter.contentModelInstance.printRefContainer(s.complexTypes));
    }

    public static void dumpRELAXGrammar(RELAXGrammar m) throws Exception {
        System.out.println("operation is not implemented yet.");
    }

    public static int run(String[] args) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<URL> classPaths = new ArrayList<URL>();
        String grammarName = null;
        boolean dump = false;
        boolean verbose = false;
        boolean warning = false;
        boolean standalone = false;
        boolean strict = false;
        boolean usePanicMode = true;
        CatalogResolver entityResolver = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-?")) {
                Driver.usage();
                return -1;
            }
            if (args[i].equalsIgnoreCase("-strict")) {
                strict = true;
            } else if (args[i].equalsIgnoreCase("-standalone")) {
                standalone = true;
            } else if (args[i].equalsIgnoreCase("-loose")) {
                standalone = true;
            } else if (!args[i].equalsIgnoreCase("-dtd")) {
                if (args[i].equalsIgnoreCase("-dump")) {
                    dump = true;
                } else if (args[i].equalsIgnoreCase("-debug")) {
                    Debug.debug = true;
                } else if (args[i].equalsIgnoreCase("-xerces")) {
                    factory = (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
                } else if (args[i].equalsIgnoreCase("-crimson")) {
                    factory = (SAXParserFactory)Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl").newInstance();
                } else if (args[i].equalsIgnoreCase("-oraclev2")) {
                    factory = (SAXParserFactory)Class.forName("oracle.xml.jaxp.JXSAXParserFactory").newInstance();
                } else if (args[i].equalsIgnoreCase("-verbose")) {
                    verbose = true;
                } else if (args[i].equalsIgnoreCase("-warning")) {
                    warning = true;
                } else if (args[i].equalsIgnoreCase("-maxerror")) {
                    usePanicMode = false;
                } else if (args[i].equalsIgnoreCase("-locale")) {
                    String code;
                    int idx;
                    if ((idx = (code = args[++i]).indexOf(45)) < 0) {
                        idx = code.indexOf(95);
                    }
                    if (idx < 0) {
                        Locale.setDefault(new Locale(code, ""));
                    } else {
                        Locale.setDefault(new Locale(code.substring(0, idx), code.substring(idx + 1)));
                    }
                } else if (args[i].equalsIgnoreCase("-classpath")) {
                    classPaths.add(new File(args[++i]).toURL());
                } else if (args[i].equalsIgnoreCase("-catalog")) {
                    if (entityResolver == null) {
                        entityResolver = new CatalogResolver(true);
                    }
                    ((CatalogResolver)entityResolver).getCatalog().parseCatalog(args[++i]);
                } else {
                    if (args[i].equalsIgnoreCase("-version")) {
                        Driver.printVersion();
                        return 0;
                    }
                    if (args[i].charAt(0) == '-') {
                        System.err.println(Driver.localize(MSG_UNRECOGNIZED_OPTION, args[i]));
                        Driver.usage();
                        return -1;
                    }
                    if (grammarName == null) {
                        grammarName = args[i];
                    } else {
                        fileNames.add(args[i]);
                    }
                }
            }
            ++i;
        }
        if (grammarName == null) {
            System.out.println(Driver.localize(MSG_USAGE));
            return -1;
        }
        if (verbose) {
            Driver.printVersion();
        }
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
        }
        if (verbose) {
            System.out.println(Driver.localize(MSG_PARSER, factory.getClass().getName()));
        }
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        if (!standalone && verbose) {
            System.out.println(Driver.localize(MSG_DTDVALIDATION));
        }
        if (standalone) {
            try {
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception e) {
                System.out.println(Driver.localize(MSG_FAILED_TO_IGNORE_EXTERNAL_DTD));
            }
        } else {
            try {
                factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                factory.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long stime = System.currentTimeMillis();
        System.out.println(Driver.localize(MSG_START_PARSING_GRAMMAR));
        Grammar grammar = null;
        try {
            GrammarLoader loader = new GrammarLoader();
            loader.setController(new DebugController(warning, false, (EntityResolver)entityResolver));
            loader.setSAXParserFactory(factory);
            loader.setStrictCheck(strict);
            grammar = loader.parse(grammarName);
        }
        catch (SAXParseException spe) {
            if (Debug.debug) {
                spe.getException().printStackTrace();
            }
        }
        catch (SAXException se) {
            if (se.getException() != null) {
                throw se.getException();
            }
            throw se;
        }
        if (grammar == null) {
            System.out.println(Driver.localize(ERR_LOAD_GRAMMAR));
            return -1;
        }
        long parsingTime = System.currentTimeMillis();
        if (verbose) {
            System.out.println(Driver.localize(MSG_PARSING_TIME, new Long(parsingTime - stime)));
        }
        if (dump) {
            if (grammar instanceof RELAXModule) {
                Driver.dumpRELAXModule((RELAXModule)grammar);
            } else if (grammar instanceof RELAXGrammar) {
                Driver.dumpRELAXGrammar((RELAXGrammar)grammar);
            } else if (grammar instanceof TREXGrammar) {
                Driver.dumpTREX((TREXGrammar)grammar);
            } else if (grammar instanceof XMLSchemaGrammar) {
                Driver.dumpXMLSchema((XMLSchemaGrammar)grammar);
            }
            return -1;
        }
        DocumentVerifier verifier = grammar instanceof RELAXGrammar ? new RELAXNSVerifier(new SchemaProviderImpl((RELAXGrammar)grammar)) : (grammar instanceof XMLSchemaGrammar ? new XMLSchemaVerifier((XMLSchemaGrammar)grammar) : new SimpleVerifier(new REDocumentDeclaration(grammar)));
        boolean allValid = true;
        int i2 = 0;
        while (i2 < fileNames.size()) {
            boolean result;
            block76: {
                String instName = (String)fileNames.get(i2);
                System.out.println(Driver.localize(MSG_VALIDATING, instName));
                result = false;
                try {
                    XMLReader reader = factory.newSAXParser().getXMLReader();
                    if (entityResolver != null) {
                        reader.setEntityResolver((EntityResolver)entityResolver);
                    }
                    reader.setErrorHandler(new ReportErrorHandler());
                    result = verifier.verify(reader, Util.getInputSource(instName), usePanicMode);
                }
                catch (ValidationUnrecoverableException vv) {
                    System.out.println(Driver.localize(MSG_BAILOUT));
                }
                catch (SAXParseException se) {
                    if (se.getException() != null) {
                        se.getException().printStackTrace();
                    }
                }
                catch (SAXException e) {
                    if (e.getException() == null) break block76;
                    e.getException().printStackTrace();
                }
            }
            if (result) {
                System.out.println(Driver.localize(MSG_VALID));
            } else {
                System.out.println(Driver.localize(MSG_INVALID));
                allValid = false;
            }
            if (i2 != fileNames.size() - 1) {
                System.out.println("--------------------------------------");
            }
            ++i2;
        }
        if (verbose) {
            System.out.println(Driver.localize(MSG_VALIDATION_TIME, new Long(System.currentTimeMillis() - parsingTime)));
        }
        return allValid ? 0 : -1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(Driver.run(args));
    }

    public static String localize(String prop) {
        return Driver.localize(prop, null);
    }

    public static String localize(String prop, Object arg1) {
        return Driver.localize(prop, new Object[]{arg1});
    }

    public static String localize(String propertyName, Object[] args) {
        String format = ResourceBundle.getBundle("com.sun.msv.driver.textui.Messages").getString(propertyName);
        return MessageFormat.format(format, args);
    }

    public static String localize(String prop, Object arg1, Object arg2) {
        return Driver.localize(prop, new Object[]{arg1, arg2});
    }

    private static interface DocumentVerifier {
        public boolean verify(XMLReader var1, InputSource var2, boolean var3) throws Exception;
    }

    private static class RELAXNSVerifier
    implements DocumentVerifier {
        private final SchemaProvider sp;

        RELAXNSVerifier(SchemaProvider sp) {
            this.sp = sp;
        }

        public boolean verify(XMLReader p, InputSource instance, boolean panicMode) throws Exception {
            DispatcherImpl dispatcher = new DispatcherImpl(this.sp);
            dispatcher.attachXMLReader(p);
            ReportErrorHandler errorHandler = new ReportErrorHandler();
            dispatcher.setErrorHandler(errorHandler);
            p.parse(instance);
            return !errorHandler.hadError;
        }
    }

    private static class SimpleVerifier
    implements DocumentVerifier {
        private final DocumentDeclaration docDecl;

        SimpleVerifier(DocumentDeclaration docDecl) {
            this.docDecl = docDecl;
        }

        public boolean verify(XMLReader p, InputSource instance, boolean panicMode) throws Exception {
            ReportErrorHandler reh = new ReportErrorHandler();
            Verifier v = new Verifier(this.docDecl, reh);
            v.setPanicMode(panicMode);
            p.setDTDHandler(v);
            p.setContentHandler(v);
            p.setErrorHandler(reh);
            p.parse(instance);
            return v.isValid();
        }
    }

    private static class XMLSchemaVerifier
    implements DocumentVerifier {
        private final XMLSchemaGrammar grammar;

        XMLSchemaVerifier(XMLSchemaGrammar grammar) {
            this.grammar = grammar;
        }

        public boolean verify(XMLReader p, InputSource instance, boolean panicMode) throws Exception {
            ReportErrorHandler reh = new ReportErrorHandler();
            IDConstraintChecker v = new IDConstraintChecker(this.grammar, (ErrorHandler)reh);
            v.setPanicMode(panicMode);
            p.setDTDHandler(v);
            p.setContentHandler(v);
            p.setErrorHandler(reh);
            p.parse(instance);
            return v.isValid();
        }
    }
}

