# src/resources/dbpowder/dbpowder.properties, *Connection.properties 
# KvɉĕύXĂB
#
# local  mysql ŁAftHgݒ̂܂ܖ{ sample 𓮍삳邽߂ɂ́A
# ȉ̃R}hsĂB
#
#    $ mysql -u root -p
#
#    mysql> create database db_sample;
#    mysql> grant all privileges on db_sample.* to user_sample@localhost identified by 'tiger';
#


CREATE TABLE user_type (
  user_type_id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  user_type_name TEXT NOT NULL,
  PRIMARY KEY(user_type_id)
)
TYPE=InnoDB;

CREATE TABLE group_mst (
  group_id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  group_name TEXT NOT NULL,
  PRIMARY KEY(group_id)
)
TYPE=InnoDB;

CREATE TABLE user_mst (
  user_id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  group_id INTEGER UNSIGNED NOT NULL,
  user_type_id INTEGER UNSIGNED NOT NULL,
  user_name TEXT NOT NULL,
  PRIMARY KEY(user_id),
  INDEX user_mst_FKIndex1(user_type_id),
  INDEX user_mst_FKIndex2(group_id),
  FOREIGN KEY(user_type_id)
    REFERENCES user_type(user_type_id)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION,
  FOREIGN KEY(group_id)
    REFERENCES group_mst(group_id)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION
)
TYPE=InnoDB;

CREATE TABLE log_header (
  header_id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  user_id INTEGER UNSIGNED NOT NULL,
  login_datetime DATETIME NOT NULL,
  logout_datetime DATETIME NULL,
  PRIMARY KEY(header_id, user_id),
  INDEX log_header_FKIndex1(user_id),
  FOREIGN KEY(user_id)
    REFERENCES user_mst(user_id)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION
)
TYPE=InnoDB;

CREATE TABLE log_body (
  user_id INTEGER UNSIGNED NOT NULL,
  header_id INTEGER UNSIGNED NOT NULL,
  body_id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  action TEXT NOT NULL,
  PRIMARY KEY(user_id, header_id, body_id),
  INDEX log_body_FKIndex1(header_id, user_id),
  FOREIGN KEY(header_id, user_id)
    REFERENCES log_header(header_id, user_id)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION
)
TYPE=InnoDB;



insert into user_type (user_type_name) values ('admin');
insert into user_type (user_type_name) values ('powerUser');
insert into user_type (user_type_name) values ('user');
insert into user_type (user_type_name) values ('guest');

insert into group_mst (group_name) values ('group1');
insert into group_mst (group_name) values ('group2');
insert into group_mst (group_name) values ('group3');
insert into group_mst (group_name) values ('group4');

insert into user_mst (group_id, user_type_id, user_name) values (1,1,'dbpowder');
insert into user_mst (group_id, user_type_id, user_name) values (1,2,'John');
insert into user_mst (group_id, user_type_id, user_name) values (2,3,'Nancy');
insert into user_mst (group_id, user_type_id, user_name) values (3,4,'Bob');
insert into user_mst (group_id, user_type_id, user_name) values (4,4,'Hanako');

insert into log_header (user_id, login_datetime, logout_datetime) values (1,'2004-06-02 12:34', '2004-06-02 17:24');
insert into log_header (user_id, login_datetime, logout_datetime) values (1,'2004-07-21 14:14', '2004-07-21 16:56');
insert into log_header (user_id, login_datetime, logout_datetime) values (1,'2004-08-10 13:33', '2004-08-14 14:53');
insert into log_header (user_id, login_datetime, logout_datetime) values (2,'2004-06-23 16:54', '2004-06-23 19:15');
insert into log_header (user_id, login_datetime, logout_datetime) values (2,'2004-07-03 17:43', '2004-07-03 18:59');
insert into log_header (user_id, login_datetime, logout_datetime) values (2,'2004-07-28 09:23', '2004-07-28 11:43');
insert into log_header (user_id, login_datetime, logout_datetime) values (2,'2004-08-09 21:11',  null             );
insert into log_header (user_id, login_datetime, logout_datetime) values (3,'2004-05-30 16:56', '2004-05-30 21:12');
insert into log_header (user_id, login_datetime, logout_datetime) values (3,'2004-06-12 00:52', '2004-06-12 04:34');
insert into log_header (user_id, login_datetime, logout_datetime) values (3,'2004-07-09 05:18', '2004-07-09 07:24');
insert into log_header (user_id, login_datetime, logout_datetime) values (3,'2004-07-27 23:07', '2004-07-28 02:13');
insert into log_header (user_id, login_datetime, logout_datetime) values (3,'2004-08-05 21:04',  null             );
insert into log_header (user_id, login_datetime, logout_datetime) values (4,'2004-06-22 17:43', '2004-06-22 10:31');
insert into log_header (user_id, login_datetime, logout_datetime) values (4,'2004-07-25 16:36', '2004-07-25 18:46');
insert into log_header (user_id, login_datetime, logout_datetime) values (4,'2004-08-02 09:21', '2004-08-02 12:19');
insert into log_header (user_id, login_datetime, logout_datetime) values (4,'2004-08-06 10:02',  null             );

insert into log_body (user_id, header_id, action) values (1, 1,'watch log');
insert into log_body (user_id, header_id, action) values (1, 2,'install application');
insert into log_body (user_id, header_id, action) values (1, 3,'create user');
insert into log_body (user_id, header_id, action) values (2, 4,'gather data');
insert into log_body (user_id, header_id, action) values (2, 5,'play game');
insert into log_body (user_id, header_id, action) values (2, 6,'homework');
insert into log_body (user_id, header_id, action) values (2, 7,'mail');
insert into log_body (user_id, header_id, action) values (3, 8,'download');
insert into log_body (user_id, header_id, action) values (3, 9,'brouse web');
insert into log_body (user_id, header_id, action) values (3,10,'play game');
insert into log_body (user_id, header_id, action) values (3,11,'analyze');
insert into log_body (user_id, header_id, action) values (3,12,'compose music');
insert into log_body (user_id, header_id, action) values (4,13,'read faq');
insert into log_body (user_id, header_id, action) values (4,14,'read sample page');
insert into log_body (user_id, header_id, action) values (4,15,'use some applictions');
insert into log_body (user_id, header_id, action) values (4,16,'');

